/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.webapp.BadRequestException;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@Path(value="/ws/v1/applicationhistory")
public class AHSWebServices
extends WebServices {
    @Inject
    public AHSWebServices(ApplicationContext appContext) {
        super(appContext);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo get(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        return this.getApps(req, res, null, Collections.emptySet(), null, null, null, null, null, null, null, null, Collections.emptySet());
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo getApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes) {
        this.init(res);
        AHSWebServices.validateStates((String)stateQuery, statesQuery);
        return super.getApps(req, res, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json", "application/xml"})
    public AppInfo getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getApp(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json", "application/xml"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getAppAttempts(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json", "application/xml"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json", "application/xml"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json", "application/xml"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.init(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    private static void validateStates(String stateQuery, Set<String> statesQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        Set appStates = AHSWebServices.parseQueries(statesQuery, (boolean)true);
        block3: for (String appState : appStates) {
            switch (1.$SwitchMap$org$apache$hadoop$yarn$api$records$YarnApplicationState[YarnApplicationState.valueOf((String)appState.toUpperCase()).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    continue block3;
                }
            }
            throw new BadRequestException("Invalid application-state " + appState + " specified. It should be a final state");
        }
    }
}

