/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerStartData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryApplicationHistoryStore
extends AbstractService
implements ApplicationHistoryStore {
    private final ConcurrentMap<ApplicationId, ApplicationHistoryData> applicationData = new ConcurrentHashMap();
    private final ConcurrentMap<ApplicationId, ConcurrentMap<ApplicationAttemptId, ApplicationAttemptHistoryData>> applicationAttemptData = new ConcurrentHashMap();
    private final ConcurrentMap<ApplicationAttemptId, ConcurrentMap<ContainerId, ContainerHistoryData>> containerData = new ConcurrentHashMap();

    public MemoryApplicationHistoryStore() {
        super(MemoryApplicationHistoryStore.class.getName());
    }

    public Map<ApplicationId, ApplicationHistoryData> getAllApplications() {
        return new HashMap<ApplicationId, ApplicationHistoryData>(this.applicationData);
    }

    public ApplicationHistoryData getApplication(ApplicationId appId) {
        return (ApplicationHistoryData)this.applicationData.get(appId);
    }

    public Map<ApplicationAttemptId, ApplicationAttemptHistoryData> getApplicationAttempts(ApplicationId appId) {
        ConcurrentMap subMap = (ConcurrentMap)this.applicationAttemptData.get(appId);
        if (subMap == null) {
            return Collections.emptyMap();
        }
        return new HashMap<ApplicationAttemptId, ApplicationAttemptHistoryData>(subMap);
    }

    public ApplicationAttemptHistoryData getApplicationAttempt(ApplicationAttemptId appAttemptId) {
        ConcurrentMap subMap = (ConcurrentMap)this.applicationAttemptData.get(appAttemptId.getApplicationId());
        if (subMap == null) {
            return null;
        }
        return (ApplicationAttemptHistoryData)subMap.get(appAttemptId);
    }

    public ContainerHistoryData getAMContainer(ApplicationAttemptId appAttemptId) {
        ApplicationAttemptHistoryData appAttempt = this.getApplicationAttempt(appAttemptId);
        if (appAttempt == null || appAttempt.getMasterContainerId() == null) {
            return null;
        }
        return this.getContainer(appAttempt.getMasterContainerId());
    }

    public ContainerHistoryData getContainer(ContainerId containerId) {
        Map subMap = (Map)this.containerData.get(containerId.getApplicationAttemptId());
        if (subMap == null) {
            return null;
        }
        return (ContainerHistoryData)subMap.get(containerId);
    }

    public Map<ContainerId, ContainerHistoryData> getContainers(ApplicationAttemptId appAttemptId) throws IOException {
        ConcurrentMap subMap = (ConcurrentMap)this.containerData.get(appAttemptId);
        if (subMap == null) {
            return Collections.emptyMap();
        }
        return new HashMap<ContainerId, ContainerHistoryData>(subMap);
    }

    public void applicationStarted(ApplicationStartData appStart) throws IOException {
        ApplicationHistoryData oldData = this.applicationData.putIfAbsent(appStart.getApplicationId(), ApplicationHistoryData.newInstance((ApplicationId)appStart.getApplicationId(), (String)appStart.getApplicationName(), (String)appStart.getApplicationType(), (String)appStart.getQueue(), (String)appStart.getUser(), (long)appStart.getSubmitTime(), (long)appStart.getStartTime(), (long)Long.MAX_VALUE, null, null, null));
        if (oldData != null) {
            throw new IOException("The start information of application " + appStart.getApplicationId() + " is already stored.");
        }
    }

    public void applicationFinished(ApplicationFinishData appFinish) throws IOException {
        ApplicationHistoryData data = (ApplicationHistoryData)this.applicationData.get(appFinish.getApplicationId());
        if (data == null) {
            throw new IOException("The finish information of application " + appFinish.getApplicationId() + " is stored before the start" + " information.");
        }
        if (data.getYarnApplicationState() != null) {
            throw new IOException("The finish information of application " + appFinish.getApplicationId() + " is already stored.");
        }
        data.setFinishTime(appFinish.getFinishTime());
        data.setDiagnosticsInfo(appFinish.getDiagnosticsInfo());
        data.setFinalApplicationStatus(appFinish.getFinalApplicationStatus());
        data.setYarnApplicationState(appFinish.getYarnApplicationState());
    }

    public void applicationAttemptStarted(ApplicationAttemptStartData appAttemptStart) throws IOException {
        ConcurrentMap subMap = this.getSubMap(appAttemptStart.getApplicationAttemptId().getApplicationId());
        ApplicationAttemptHistoryData oldData = subMap.putIfAbsent(appAttemptStart.getApplicationAttemptId(), ApplicationAttemptHistoryData.newInstance((ApplicationAttemptId)appAttemptStart.getApplicationAttemptId(), (String)appAttemptStart.getHost(), (int)appAttemptStart.getRPCPort(), (ContainerId)appAttemptStart.getMasterContainerId(), null, null, null, null));
        if (oldData != null) {
            throw new IOException("The start information of application attempt " + appAttemptStart.getApplicationAttemptId() + " is already stored.");
        }
    }

    public void applicationAttemptFinished(ApplicationAttemptFinishData appAttemptFinish) throws IOException {
        ConcurrentMap subMap = this.getSubMap(appAttemptFinish.getApplicationAttemptId().getApplicationId());
        ApplicationAttemptHistoryData data = (ApplicationAttemptHistoryData)subMap.get(appAttemptFinish.getApplicationAttemptId());
        if (data == null) {
            throw new IOException("The finish information of application attempt " + appAttemptFinish.getApplicationAttemptId() + " is stored before" + " the start information.");
        }
        if (data.getYarnApplicationAttemptState() != null) {
            throw new IOException("The finish information of application attempt " + appAttemptFinish.getApplicationAttemptId() + " is already stored.");
        }
        data.setTrackingURL(appAttemptFinish.getTrackingURL());
        data.setDiagnosticsInfo(appAttemptFinish.getDiagnosticsInfo());
        data.setFinalApplicationStatus(appAttemptFinish.getFinalApplicationStatus());
        data.setYarnApplicationAttemptState(appAttemptFinish.getYarnApplicationAttemptState());
    }

    private ConcurrentMap<ApplicationAttemptId, ApplicationAttemptHistoryData> getSubMap(ApplicationId appId) {
        this.applicationAttemptData.putIfAbsent(appId, new ConcurrentHashMap());
        return (ConcurrentMap)this.applicationAttemptData.get(appId);
    }

    public void containerStarted(ContainerStartData containerStart) throws IOException {
        ConcurrentMap subMap = this.getSubMap(containerStart.getContainerId().getApplicationAttemptId());
        ContainerHistoryData oldData = subMap.putIfAbsent(containerStart.getContainerId(), ContainerHistoryData.newInstance((ContainerId)containerStart.getContainerId(), (Resource)containerStart.getAllocatedResource(), (NodeId)containerStart.getAssignedNode(), (Priority)containerStart.getPriority(), (long)containerStart.getStartTime(), (long)Long.MAX_VALUE, null, (int)Integer.MAX_VALUE, null));
        if (oldData != null) {
            throw new IOException("The start information of container " + containerStart.getContainerId() + " is already stored.");
        }
    }

    public void containerFinished(ContainerFinishData containerFinish) throws IOException {
        ConcurrentMap subMap = this.getSubMap(containerFinish.getContainerId().getApplicationAttemptId());
        ContainerHistoryData data = (ContainerHistoryData)subMap.get(containerFinish.getContainerId());
        if (data == null) {
            throw new IOException("The finish information of container " + containerFinish.getContainerId() + " is stored before" + " the start information.");
        }
        if (data.getContainerState() != null) {
            throw new IOException("The finish information of container " + containerFinish.getContainerId() + " is already stored.");
        }
        data.setFinishTime(containerFinish.getFinishTime());
        data.setDiagnosticsInfo(containerFinish.getDiagnosticsInfo());
        data.setContainerExitStatus(containerFinish.getContainerExitStatus());
        data.setContainerState(containerFinish.getContainerState());
    }

    private ConcurrentMap<ContainerId, ContainerHistoryData> getSubMap(ApplicationAttemptId appAttemptId) {
        this.containerData.putIfAbsent(appAttemptId, new ConcurrentHashMap());
        return (ConcurrentMap)this.containerData.get(appAttemptId);
    }
}

