/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebApp;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryServer.class);
    ApplicationHistoryClientService ahsClientService;
    ApplicationHistoryManager historyManager;
    TimelineStore timelineStore;
    private WebApp webApp;

    public ApplicationHistoryServer() {
        super(ApplicationHistoryServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.historyManager = this.createApplicationHistory();
        this.ahsClientService = this.createApplicationHistoryClientService(this.historyManager);
        this.addService((Service)this.ahsClientService);
        this.addService((Service)this.historyManager);
        this.timelineStore = this.createTimelineStore(conf);
        this.addIfService((Object)this.timelineStore);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        DefaultMetricsSystem.initialize((String)"ApplicationHistoryServer");
        JvmMetrics.initSingleton((String)"ApplicationHistoryServer", null);
        this.startWebApp();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ApplicationHistoryClientService getClientService() {
        return this.ahsClientService;
    }

    protected ApplicationHistoryClientService createApplicationHistoryClientService(ApplicationHistoryManager historyManager) {
        return new ApplicationHistoryClientService(historyManager);
    }

    protected ApplicationHistoryManager createApplicationHistory() {
        return new ApplicationHistoryManagerImpl();
    }

    protected ApplicationHistoryManager getApplicationHistory() {
        return this.historyManager;
    }

    static ApplicationHistoryServer launchAppHistoryServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ApplicationHistoryServer.class, (String[])args, (Log)LOG);
        ApplicationHistoryServer appHistoryServer = null;
        try {
            appHistoryServer = new ApplicationHistoryServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)appHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration();
            appHistoryServer.init((Configuration)conf);
            appHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ApplicationHistoryServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting ApplicationHistoryServer");
        }
        return appHistoryServer;
    }

    public static void main(String[] args) {
        ApplicationHistoryServer.launchAppHistoryServer((String[])args);
    }

    protected ApplicationHistoryManager createApplicationHistoryManager(Configuration conf) {
        return new ApplicationHistoryManagerImpl();
    }

    protected TimelineStore createTimelineStore(Configuration conf) {
        return (TimelineStore)ReflectionUtils.newInstance((Class)conf.getClass("yarn.timeline-service.store-class", LeveldbTimelineStore.class, TimelineStore.class), (Configuration)conf);
    }

    protected void startWebApp() {
        String bindAddress = WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)this.getConfig());
        LOG.info((Object)("Instantiating AHSWebApp at " + bindAddress));
        try {
            this.webApp = WebApps.$for((String)"applicationhistory", ApplicationHistoryClientService.class, (Object)this.ahsClientService, (String)"ws").with(this.getConfig()).withHttpSpnegoPrincipalKey("yarn.timeline-service.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.timeline-service.webapp.spnego-keytab-file").at(bindAddress).start((WebApp)new AHSWebApp(this.historyManager, this.timelineStore));
        }
        catch (Exception e) {
            String msg = "AHSWebApp failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelineStore getTimelineStore() {
        return this.timelineStore;
    }
}

