/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;

public class ApplicationHistoryClientService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryClientService.class);
    private ApplicationHistoryManager history;
    private ApplicationHistoryProtocol protocolHandler;
    private Server server;
    private InetSocketAddress bindAddress;

    public ApplicationHistoryClientService(ApplicationHistoryManager history) {
        super("ApplicationHistoryClientService");
        this.history = history;
        this.protocolHandler = new ApplicationHSClientProtocolHandler();
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = conf.getSocketAddr("yarn.timeline-service.address", "0.0.0.0:10200", 10200);
        this.server = rpc.getServer(ApplicationHistoryProtocol.class, (Object)this.protocolHandler, address, conf, null, conf.getInt("yarn.timeline-service.handler-thread-count", 10));
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("yarn.timeline-service.address", this.server.getListenerAddress());
        LOG.info((Object)("Instantiated ApplicationHistoryClientService at " + this.bindAddress));
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public ApplicationHistoryProtocol getClientHandler() {
        return this.protocolHandler;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    private class ApplicationHSClientProtocolHandler
    implements ApplicationHistoryProtocol {
        private ApplicationHSClientProtocolHandler() {
        }

        public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
            return null;
        }

        public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
            try {
                GetApplicationAttemptReportResponse response = GetApplicationAttemptReportResponse.newInstance((ApplicationAttemptReport)ApplicationHistoryClientService.this.history.getApplicationAttempt(request.getApplicationAttemptId()));
                return response;
            }
            catch (IOException e) {
                throw new ApplicationAttemptNotFoundException(e.getMessage());
            }
        }

        public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
            GetApplicationAttemptsResponse response = GetApplicationAttemptsResponse.newInstance(new ArrayList(ApplicationHistoryClientService.this.history.getApplicationAttempts(request.getApplicationId()).values()));
            return response;
        }

        public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
            try {
                ApplicationId applicationId = request.getApplicationId();
                GetApplicationReportResponse response = GetApplicationReportResponse.newInstance((ApplicationReport)ApplicationHistoryClientService.this.history.getApplication(applicationId));
                return response;
            }
            catch (IOException e) {
                throw new ApplicationNotFoundException(e.getMessage());
            }
        }

        public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
            GetApplicationsResponse response = GetApplicationsResponse.newInstance(new ArrayList(ApplicationHistoryClientService.this.history.getAllApplications().values()));
            return response;
        }

        public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
            try {
                GetContainerReportResponse response = GetContainerReportResponse.newInstance((ContainerReport)ApplicationHistoryClientService.this.history.getContainer(request.getContainerId()));
                return response;
            }
            catch (IOException e) {
                throw new ContainerNotFoundException(e.getMessage());
            }
        }

        public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
            GetContainersResponse response = GetContainersResponse.newInstance(new ArrayList(ApplicationHistoryClientService.this.history.getContainers(request.getApplicationAttemptId()).values()));
            return response;
        }

        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
            return null;
        }

        public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

