/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TestAHSWebApp;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TestAHSWebServices;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAHSWebServices
extends JerseyTest {
    private static ApplicationHistoryManager ahManager;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    private ApplicationHistoryManager mockApplicationHistoryManager() throws Exception {
        MemoryApplicationHistoryStore store = new MemoryApplicationHistoryStore();
        TestAHSWebApp testAHSWebApp = new TestAHSWebApp();
        testAHSWebApp.setApplicationHistoryStore((ApplicationHistoryStore)store);
        ApplicationHistoryManager ahManager = testAHSWebApp.mockApplicationHistoryManager(5, 5, 5);
        return ahManager;
    }

    public TestAHSWebServices() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").path("bogus").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testAppsQuery() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("state", YarnApplicationState.FINISHED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject app = json.getJSONObject("app");
        Assert.assertEquals((Object)appId.toString(), (Object)app.getString("appId"));
        Assert.assertEquals((Object)appId.toString(), (Object)app.get("name"));
        Assert.assertEquals((Object)appId.toString(), (Object)app.get("diagnosticsInfo"));
        Assert.assertEquals((Object)"test queue", (Object)app.get("queue"));
        Assert.assertEquals((Object)"test user", (Object)app.get("user"));
        Assert.assertEquals((Object)"test type", (Object)app.get("type"));
        Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), (Object)app.get("finalAppStatus"));
        Assert.assertEquals((Object)YarnApplicationState.FINISHED.toString(), (Object)app.get("appState"));
    }

    @Test
    public void testMultipleAttempts() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appAttempts.length());
        JSONArray array = appAttempts.getJSONArray("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleAttempt() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempt = json.getJSONObject("appAttempt");
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("appAttemptId"));
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("host"));
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"test tracking url", (Object)appAttempt.getString("trackingUrl"));
        Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), (Object)appAttempt.get("appAttemptState"));
    }

    @Test
    public void testMultipleContainers() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject containers = json.getJSONObject("containers");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)containers.length());
        JSONArray array = containers.getJSONArray("container");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleContainer() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject container = json.getJSONObject("container");
        Assert.assertEquals((Object)containerId.toString(), (Object)container.getString("containerId"));
        Assert.assertEquals((Object)containerId.toString(), (Object)container.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"0", (Object)container.getString("allocatedMB"));
        Assert.assertEquals((Object)"0", (Object)container.getString("allocatedVCores"));
        Assert.assertEquals((Object)NodeId.newInstance((String)"localhost", (int)0).toString(), (Object)container.getString("assignedNodeId"));
        Assert.assertEquals((Object)Priority.newInstance((int)containerId.getId()).toString(), (Object)container.getString("priority"));
        YarnConfiguration conf = new YarnConfiguration();
        Assert.assertEquals((Object)(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf) + "/applicationhistory/logs/localhost:0/container_0_0001_01_000001/" + "container_0_0001_01_000001/test user"), (Object)container.getString("logUrl"));
        Assert.assertEquals((Object)ContainerState.COMPLETE.toString(), (Object)container.getString("containerState"));
    }

    static /* synthetic */ ApplicationHistoryManager access$002(ApplicationHistoryManager x0) {
        ahManager = x0;
        return ahManager;
    }

    static /* synthetic */ ApplicationHistoryManager access$100(TestAHSWebServices x0) throws Exception {
        return x0.mockApplicationHistoryManager();
    }

    static /* synthetic */ ApplicationHistoryManager access$000() {
        return ahManager;
    }

    static /* synthetic */ Injector access$200(TestAHSWebServices x0) {
        return x0.injector;
    }
}

