/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.GenericObjectMapper;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TestGenericObjectMapper {
    @Test
    public void testEncoding() {
        TestGenericObjectMapper.testEncoding((long)Long.MAX_VALUE);
        TestGenericObjectMapper.testEncoding((long)Long.MIN_VALUE);
        TestGenericObjectMapper.testEncoding((long)0L);
        TestGenericObjectMapper.testEncoding((long)128L);
        TestGenericObjectMapper.testEncoding((long)256L);
        TestGenericObjectMapper.testEncoding((long)512L);
        TestGenericObjectMapper.testEncoding((long)-256L);
    }

    private static void testEncoding(long l) {
        byte[] b = GenericObjectMapper.writeReverseOrderedLong((long)l);
        Assert.assertEquals((String)"error decoding", (long)l, (long)GenericObjectMapper.readReverseOrderedLong((byte[])b, (int)0));
        byte[] buf = new byte[16];
        System.arraycopy(b, 0, buf, 5, 8);
        Assert.assertEquals((String)"error decoding at offset", (long)l, (long)GenericObjectMapper.readReverseOrderedLong((byte[])buf, (int)5));
        if (l > Long.MIN_VALUE) {
            byte[] a = GenericObjectMapper.writeReverseOrderedLong((long)(l - 1L));
            Assert.assertEquals((String)"error preserving ordering", (long)1L, (long)WritableComparator.compareBytes((byte[])a, (int)0, (int)a.length, (byte[])b, (int)0, (int)b.length));
        }
        if (l < Long.MAX_VALUE) {
            byte[] c = GenericObjectMapper.writeReverseOrderedLong((long)(l + 1L));
            Assert.assertEquals((String)"error preserving ordering", (long)1L, (long)WritableComparator.compareBytes((byte[])b, (int)0, (int)b.length, (byte[])c, (int)0, (int)c.length));
        }
    }

    private static void verify(Object o) throws IOException {
        Assert.assertEquals((Object)o, (Object)GenericObjectMapper.read((byte[])GenericObjectMapper.write((Object)o)));
    }

    @Test
    public void testValueTypes() throws IOException {
        TestGenericObjectMapper.verify((Object)Integer.MAX_VALUE);
        TestGenericObjectMapper.verify((Object)Integer.MIN_VALUE);
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)GenericObjectMapper.read((byte[])GenericObjectMapper.write((Object)Integer.MAX_VALUE)));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)GenericObjectMapper.read((byte[])GenericObjectMapper.write((Object)Integer.MIN_VALUE)));
        TestGenericObjectMapper.verify((Object)0x80000000L);
        TestGenericObjectMapper.verify((Object)-2147483649L);
        TestGenericObjectMapper.verify((Object)Long.MAX_VALUE);
        TestGenericObjectMapper.verify((Object)Long.MIN_VALUE);
        Assert.assertEquals((Object)42, (Object)GenericObjectMapper.read((byte[])GenericObjectMapper.write((Object)42L)));
        TestGenericObjectMapper.verify((Object)42);
        TestGenericObjectMapper.verify((Object)1.23);
        TestGenericObjectMapper.verify((Object)"abc");
        TestGenericObjectMapper.verify((Object)true);
        ArrayList<String> list = new ArrayList<String>();
        list.add("123");
        list.add("abc");
        TestGenericObjectMapper.verify(list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "v2");
        TestGenericObjectMapper.verify(map);
    }
}

