/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.timeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryTimelineStore
extends AbstractService
implements TimelineStore {
    private Map<EntityIdentifier, TimelineEntity> entities = new HashMap();
    private Map<EntityIdentifier, Long> entityInsertTimes = new HashMap();

    public MemoryTimelineStore() {
        super(MemoryTimelineStore.class.getName());
    }

    public TimelineEntities getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, String fromId, Long fromTs, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields) {
        if (limit == null) {
            limit = 100L;
        }
        if (windowStart == null) {
            windowStart = Long.MIN_VALUE;
        }
        if (windowEnd == null) {
            windowEnd = Long.MAX_VALUE;
        }
        if (fields == null) {
            fields = EnumSet.allOf(TimelineReader.Field.class);
        }
        Iterator<Object> entityIterator = null;
        if (fromId != null) {
            TimelineEntity firstEntity = (TimelineEntity)this.entities.get(new EntityIdentifier(fromId, entityType));
            if (firstEntity == null) {
                return new TimelineEntities();
            }
            entityIterator = new TreeSet(this.entities.values()).tailSet(firstEntity, true).iterator();
        }
        if (entityIterator == null) {
            entityIterator = new PriorityQueue(this.entities.values()).iterator();
        }
        ArrayList<TimelineEntity> entitiesSelected = new ArrayList<TimelineEntity>();
        while (entityIterator.hasNext()) {
            TimelineEntity entity = (TimelineEntity)entityIterator.next();
            if ((long)entitiesSelected.size() >= limit) break;
            if (!entity.getEntityType().equals(entityType) || entity.getStartTime() <= windowStart || entity.getStartTime() > windowEnd || fromTs != null && (Long)this.entityInsertTimes.get(new EntityIdentifier(entity.getEntityId(), entity.getEntityType())) > fromTs || primaryFilter != null && !MemoryTimelineStore.matchPrimaryFilter((Map)entity.getPrimaryFilters(), (NameValuePair)primaryFilter)) continue;
            if (secondaryFilters != null) {
                boolean flag = true;
                for (NameValuePair secondaryFilter : secondaryFilters) {
                    if (secondaryFilter == null || MemoryTimelineStore.matchPrimaryFilter((Map)entity.getPrimaryFilters(), (NameValuePair)secondaryFilter) || MemoryTimelineStore.matchFilter((Map)entity.getOtherInfo(), (NameValuePair)secondaryFilter)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
            }
            entitiesSelected.add(entity);
        }
        ArrayList<TimelineEntity> entitiesToReturn = new ArrayList<TimelineEntity>();
        for (TimelineEntity entitySelected : entitiesSelected) {
            entitiesToReturn.add(MemoryTimelineStore.maskFields((TimelineEntity)entitySelected, fields));
        }
        Collections.sort(entitiesToReturn);
        TimelineEntities entitiesWrapper = new TimelineEntities();
        entitiesWrapper.setEntities(entitiesToReturn);
        return entitiesWrapper;
    }

    public TimelineEntity getEntity(String entityId, String entityType, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        TimelineEntity entity;
        if (fieldsToRetrieve == null) {
            fieldsToRetrieve = EnumSet.allOf(TimelineReader.Field.class);
        }
        if ((entity = (TimelineEntity)this.entities.get(new EntityIdentifier(entityId, entityType))) == null) {
            return null;
        }
        return MemoryTimelineStore.maskFields((TimelineEntity)entity, fieldsToRetrieve);
    }

    public TimelineEvents getEntityTimelines(String entityType, SortedSet<String> entityIds, Long limit, Long windowStart, Long windowEnd, Set<String> eventTypes) {
        TimelineEvents allEvents = new TimelineEvents();
        if (entityIds == null) {
            return allEvents;
        }
        if (limit == null) {
            limit = 100L;
        }
        if (windowStart == null) {
            windowStart = Long.MIN_VALUE;
        }
        if (windowEnd == null) {
            windowEnd = Long.MAX_VALUE;
        }
        for (String entityId : entityIds) {
            EntityIdentifier entityID = new EntityIdentifier(entityId, entityType);
            TimelineEntity entity = (TimelineEntity)this.entities.get(entityID);
            if (entity == null) continue;
            TimelineEvents.EventsOfOneEntity events = new TimelineEvents.EventsOfOneEntity();
            events.setEntityId(entityId);
            events.setEntityType(entityType);
            for (TimelineEvent event : entity.getEvents()) {
                if ((long)events.getEvents().size() >= limit) break;
                if (event.getTimestamp() <= windowStart || event.getTimestamp() > windowEnd || eventTypes != null && !eventTypes.contains(event.getEventType())) continue;
                events.addEvent(event);
            }
            allEvents.addEvent(events);
        }
        return allEvents;
    }

    public TimelinePutResponse put(TimelineEntities data) {
        TimelinePutResponse response = new TimelinePutResponse();
        for (TimelineEntity entity : data.getEntities()) {
            EntityIdentifier entityId = new EntityIdentifier(entity.getEntityId(), entity.getEntityType());
            TimelineEntity existingEntity = (TimelineEntity)this.entities.get(entityId);
            if (existingEntity == null) {
                existingEntity = new TimelineEntity();
                existingEntity.setEntityId(entity.getEntityId());
                existingEntity.setEntityType(entity.getEntityType());
                existingEntity.setStartTime(entity.getStartTime());
                this.entities.put(entityId, existingEntity);
                this.entityInsertTimes.put(entityId, System.currentTimeMillis());
            }
            if (entity.getEvents() != null) {
                if (existingEntity.getEvents() == null) {
                    existingEntity.setEvents(entity.getEvents());
                } else {
                    existingEntity.addEvents(entity.getEvents());
                }
                Collections.sort(existingEntity.getEvents());
            }
            if (existingEntity.getStartTime() == null) {
                if (existingEntity.getEvents() == null || existingEntity.getEvents().isEmpty()) {
                    TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
                    error.setEntityId(entityId.getId());
                    error.setEntityType(entityId.getType());
                    error.setErrorCode(1);
                    response.addError(error);
                    this.entities.remove(entityId);
                    this.entityInsertTimes.remove(entityId);
                    continue;
                }
                Long min = Long.MAX_VALUE;
                for (TimelineEvent e : entity.getEvents()) {
                    if (min <= e.getTimestamp()) continue;
                    min = e.getTimestamp();
                }
                existingEntity.setStartTime(min);
            }
            if (entity.getPrimaryFilters() != null) {
                if (existingEntity.getPrimaryFilters() == null) {
                    existingEntity.setPrimaryFilters(new HashMap());
                }
                for (Map.Entry pf : entity.getPrimaryFilters().entrySet()) {
                    for (Object pfo : (Set)pf.getValue()) {
                        existingEntity.addPrimaryFilter((String)pf.getKey(), MemoryTimelineStore.maybeConvert(pfo));
                    }
                }
            }
            if (entity.getOtherInfo() != null) {
                if (existingEntity.getOtherInfo() == null) {
                    existingEntity.setOtherInfo(new HashMap());
                }
                for (Map.Entry info : entity.getOtherInfo().entrySet()) {
                    existingEntity.addOtherInfo((String)info.getKey(), MemoryTimelineStore.maybeConvert(info.getValue()));
                }
            }
            if (entity.getRelatedEntities() == null) continue;
            for (Map.Entry partRelatedEntities : entity.getRelatedEntities().entrySet()) {
                if (partRelatedEntities == null) continue;
                for (String idStr : (Set)partRelatedEntities.getValue()) {
                    EntityIdentifier relatedEntityId = new EntityIdentifier(idStr, (String)partRelatedEntities.getKey());
                    TimelineEntity relatedEntity = (TimelineEntity)this.entities.get(relatedEntityId);
                    if (relatedEntity != null) {
                        relatedEntity.addRelatedEntity(existingEntity.getEntityType(), existingEntity.getEntityId());
                        continue;
                    }
                    relatedEntity = new TimelineEntity();
                    relatedEntity.setEntityId(relatedEntityId.getId());
                    relatedEntity.setEntityType(relatedEntityId.getType());
                    relatedEntity.setStartTime(existingEntity.getStartTime());
                    relatedEntity.addRelatedEntity(existingEntity.getEntityType(), existingEntity.getEntityId());
                    this.entities.put(relatedEntityId, relatedEntity);
                    this.entityInsertTimes.put(relatedEntityId, System.currentTimeMillis());
                }
            }
        }
        return response;
    }

    private static TimelineEntity maskFields(TimelineEntity entity, EnumSet<TimelineReader.Field> fields) {
        TimelineEntity entityToReturn = new TimelineEntity();
        entityToReturn.setEntityId(entity.getEntityId());
        entityToReturn.setEntityType(entity.getEntityType());
        entityToReturn.setStartTime(entity.getStartTime());
        entityToReturn.setEvents((List)(fields.contains(TimelineReader.Field.EVENTS) ? entity.getEvents() : (fields.contains(TimelineReader.Field.LAST_EVENT_ONLY) ? Arrays.asList((TimelineEvent)entity.getEvents().get(0)) : null)));
        entityToReturn.setRelatedEntities(fields.contains(TimelineReader.Field.RELATED_ENTITIES) ? entity.getRelatedEntities() : null);
        entityToReturn.setPrimaryFilters(fields.contains(TimelineReader.Field.PRIMARY_FILTERS) ? entity.getPrimaryFilters() : null);
        entityToReturn.setOtherInfo(fields.contains(TimelineReader.Field.OTHER_INFO) ? entity.getOtherInfo() : null);
        return entityToReturn;
    }

    private static boolean matchFilter(Map<String, Object> tags, NameValuePair filter) {
        Object value = tags.get(filter.getName());
        if (value == null) {
            return false;
        }
        return value.equals(filter.getValue());
    }

    private static boolean matchPrimaryFilter(Map<String, Set<Object>> tags, NameValuePair filter) {
        Set<Object> value = tags.get(filter.getName());
        if (value == null) {
            return false;
        }
        return value.contains(filter.getValue());
    }

    private static Object maybeConvert(Object o) {
        Long l;
        if (o instanceof Long && (l = (Long)o) >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return l.intValue();
        }
        return o;
    }
}

