/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.log.DFSContainerLogsUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class DFSContainerLogsBlock
extends HtmlBlock
implements YarnWebParams {
    @Override
    protected void render(HtmlBlock.Block html) {
        block10: {
            ContainerId containerId;
            try {
                containerId = ConverterUtils.toContainerId(this.$("container.id"));
            }
            catch (IllegalArgumentException ex) {
                html.h1("Invalid container ID: " + this.$("container.id"));
                return;
            }
            try {
                if (this.$("log.type").isEmpty()) {
                    List<Path> logFiles = DFSContainerLogsUtils.getContainerLogDirs(containerId);
                    try {
                        this.printLogFileDirectory(html, logFiles);
                        break block10;
                    }
                    catch (IOException e) {
                        throw new YarnRuntimeException((Throwable)e);
                    }
                }
                Path logFile = DFSContainerLogsUtils.getContainerLogFile(containerId, this.$("log.type"), this.request().getRemoteUser());
                try {
                    this.printLogFile(html, logFile);
                }
                catch (IOException e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            catch (NotFoundException ex) {
                html.h1(ex.getMessage());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLogFile(HtmlBlock.Block html, Path logFile) throws IOException {
        long length = DFSContainerLogsUtils.getFileLength(logFile);
        long start = this.$("start").isEmpty() ? -4096L : Long.parseLong(this.$("start"));
        start = start < 0L ? length + start : start;
        start = start < 0L ? 0L : start;
        long end = this.$("end").isEmpty() ? length : Long.parseLong(this.$("end"));
        end = end < 0L ? length + end : end;
        long l = end = end < 0L ? length : end;
        if (start > end) {
            html.h1("Invalid start and end values. Start: [" + start + "]" + ", end[" + end + "]");
            return;
        }
        InputStream logByteStream = null;
        try {
            logByteStream = DFSContainerLogsUtils.openLogFileForRead(this.$("container.id"), logFile);
        }
        catch (IOException ex) {
            html.h1(ex.getMessage());
            return;
        }
        try {
            long toRead = end - start;
            if (toRead < length) {
                ((HamletImpl.EImp)((Object)((Hamlet.P)((Hamlet.P)((Hamlet.P)html.p())._(new Object[]{"Showing " + toRead + " bytes. Click "})).a(this.url("logs", this.$("nm.id"), this.$("container.id"), this.$("entity.string"), this.$("app.owner"), logFile.getName(), "?start=0"), "here"))._(new Object[]{" for full log"})))._();
            }
            IOUtils.skipFully((InputStream)logByteStream, (long)start);
            InputStreamReader reader = new InputStreamReader(logByteStream);
            int bufferSize = 65536;
            char[] cbuf = new char[bufferSize];
            int len = 0;
            int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
            HamletSpec.PRE pre = html.pre();
            while ((len = reader.read(cbuf, 0, currentToRead)) > 0 && toRead > 0L) {
                ((Hamlet.PRE)pre)._(new Object[]{new String(cbuf, 0, len)});
                currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
            }
            ((HamletImpl.EImp)((Object)pre))._();
            reader.close();
        }
        catch (IOException e) {
            LOG.error("Exception reading log file " + logFile, (Throwable)e);
            html.h1("Exception reading log file" + logFile);
        }
        finally {
            if (logByteStream != null) {
                try {
                    logByteStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void printLogFileDirectory(HtmlBlock.Block html, List<Path> containerLogsDirs) throws IOException {
        Collections.sort(containerLogsDirs);
        boolean foundLogFile = false;
        for (Path containerLogsDir : containerLogsDirs) {
            Object[] logFiles = DFSContainerLogsUtils.getFilesInDir(containerLogsDir);
            if (logFiles == null) continue;
            Arrays.sort(logFiles);
            for (Object logFile : logFiles) {
                String logName = logFile.getName();
                long length = DFSContainerLogsUtils.getFileLength((Path)logFile);
                foundLogFile = true;
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).a(this.url("logs", this.$("nm.id"), this.$("container.id"), this.$("entity.string"), this.$("app.owner"), logName, "?start=-4096"), logName + " : Total file length is " + length + " bytes.")))._();
            }
        }
        if (!foundLogFile) {
            html.h1("No logs available for container " + this.$("container.id"));
            return;
        }
    }
}

