/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskBasedResourceCalculator
extends DefaultResourceCalculator {
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource((int)DiskBasedResourceCalculator.divideAndCeil((int)numerator.getMemory(), (int)denominator), (int)numerator.getVirtualCores(), (double)numerator.getDisks());
    }

    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DiskBasedResourceCalculator.roundUp((int)Math.max(r.getMemory(), minimumResource.getMemory()), (int)stepFactor.getMemory()), maximumResource.getMemory());
        return Resources.createResource((int)normalizedMemory, (int)r.getVirtualCores(), (double)r.getDisks());
    }

    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedResourceCalculator.roundUp((int)r.getMemory(), (int)stepFactor.getMemory()), (int)r.getVirtualCores(), (double)r.getDisks());
    }

    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedResourceCalculator.roundDown((int)r.getMemory(), (int)stepFactor.getMemory()), (int)r.getVirtualCores(), (double)r.getDisks());
    }

    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedResourceCalculator.roundUp((int)((int)((double)r.getMemory() * by + 0.5)), (int)stepFactor.getMemory()), (int)r.getVirtualCores(), (double)r.getDisks());
    }

    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource((int)DiskBasedResourceCalculator.roundDown((int)((int)((double)r.getMemory() * by)), (int)stepFactor.getMemory()), (int)r.getVirtualCores(), (double)r.getDisks());
    }

    public int computeAvailableContainers(Resource available, Resource required) {
        double availableContainersDisk;
        int availableContainersCpu;
        int availableContainers = 0;
        if (required.getMemory() > 0) {
            availableContainers = available.getMemory() / required.getMemory();
        }
        if (required.getVirtualCores() > 0 && (availableContainersCpu = available.getVirtualCores() / required.getVirtualCores()) < availableContainers) {
            availableContainers = availableContainersCpu;
        }
        if (required.getDisks() > 0.0 && (availableContainersDisk = Math.floor(available.getDisks() / required.getDisks())) < (double)availableContainers) {
            availableContainers = (int)availableContainersDisk;
        }
        return availableContainers;
    }
}

