/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;
import org.apache.hadoop.yarn.util.Clock;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractLivelinessMonitor<O>
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AbstractLivelinessMonitor.class);
    private Thread checkerThread;
    private volatile boolean stopped;
    public static final int DEFAULT_EXPIRE = 300000;
    private int expireInterval = 300000;
    private int monitorInterval = this.expireInterval / 3;
    private final Clock clock;
    private Map<O, Long> running = new HashMap();

    public AbstractLivelinessMonitor(String name, Clock clock) {
        super(name);
        this.clock = clock;
    }

    protected void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.checkerThread = new Thread((Runnable)new PingChecker(this, null));
        this.checkerThread.setName("Ping Checker");
        this.checkerThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.checkerThread != null) {
            this.checkerThread.interrupt();
        }
        super.serviceStop();
    }

    protected abstract void expire(O var1);

    protected void setExpireInterval(int expireInterval) {
        this.expireInterval = expireInterval;
    }

    protected void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public synchronized void receivedPing(O ob) {
        if (this.running.containsKey(ob)) {
            this.running.put(ob, this.clock.getTime());
        }
    }

    public synchronized void register(O ob) {
        this.running.put(ob, this.clock.getTime());
    }

    public synchronized void unregister(O ob) {
        this.running.remove(ob);
    }

    static /* synthetic */ boolean access$100(AbstractLivelinessMonitor x0) {
        return x0.stopped;
    }

    static /* synthetic */ Map access$200(AbstractLivelinessMonitor x0) {
        return x0.running;
    }

    static /* synthetic */ Clock access$300(AbstractLivelinessMonitor x0) {
        return x0.clock;
    }

    static /* synthetic */ int access$400(AbstractLivelinessMonitor x0) {
        return x0.expireInterval;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }

    static /* synthetic */ int access$600(AbstractLivelinessMonitor x0) {
        return x0.monitorInterval;
    }
}

