/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CancelDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CancelDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationAttemptReportRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationAttemptReportResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationAttemptsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationAttemptsResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationReportRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationReportResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerReportRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainerReportResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainersRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetContainersResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RenewDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RenewDelegationTokenResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ApplicationHistoryProtocolPBClientImpl
implements ApplicationHistoryProtocol,
Closeable {
    private ApplicationHistoryProtocolPB proxy;

    public ApplicationHistoryProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ApplicationHistoryProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (ApplicationHistoryProtocolPB)RPC.getProxy(ApplicationHistoryProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public void close() throws IOException {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetApplicationReportRequestProto requestProto = ((GetApplicationReportRequestPBImpl)request).getProto();
        try {
            return new GetApplicationReportResponsePBImpl(this.proxy.getApplicationReport(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetApplicationsRequestProto requestProto = ((GetApplicationsRequestPBImpl)request).getProto();
        try {
            return new GetApplicationsResponsePBImpl(this.proxy.getApplications(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetApplicationAttemptReportRequestProto requestProto = ((GetApplicationAttemptReportRequestPBImpl)request).getProto();
        try {
            return new GetApplicationAttemptReportResponsePBImpl(this.proxy.getApplicationAttemptReport(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetApplicationAttemptsRequestProto requestProto = ((GetApplicationAttemptsRequestPBImpl)request).getProto();
        try {
            return new GetApplicationAttemptsResponsePBImpl(this.proxy.getApplicationAttempts(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetContainerReportRequestProto requestProto = ((GetContainerReportRequestPBImpl)request).getProto();
        try {
            return new GetContainerReportResponsePBImpl(this.proxy.getContainerReport(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetContainersRequestProto requestProto = ((GetContainersRequestPBImpl)request).getProto();
        try {
            return new GetContainersResponsePBImpl(this.proxy.getContainers(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        SecurityProtos.GetDelegationTokenRequestProto requestProto = ((GetDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new GetDelegationTokenResponsePBImpl(this.proxy.getDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        SecurityProtos.RenewDelegationTokenRequestProto requestProto = ((RenewDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new RenewDelegationTokenResponsePBImpl(this.proxy.renewDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        SecurityProtos.CancelDelegationTokenRequestProto requestProto = ((CancelDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new CancelDelegationTokenResponsePBImpl(this.proxy.cancelDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }
}

