/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestWebApp {
    static final Logger LOG = LoggerFactory.getLogger(TestWebApp.class);

    String echo(String s) {
        return s;
    }

    @Test
    public void testCreate() {
        WebApp app = WebApps.$for((Object)this).start();
        app.stop();
    }

    @Test
    public void testCreateWithPort() {
        WebApp app = WebApps.$for((Object)this).at(0).start();
        int port = app.getListenerAddress().getPort();
        Assert.assertTrue((port > 0 ? 1 : 0) != 0);
        app.stop();
        app = WebApps.$for((Object)this).at(port).start();
        Assert.assertEquals((long)port, (long)app.getListenerAddress().getPort());
        app.stop();
    }

    @Test(expected=WebAppException.class)
    public void testCreateWithBindAddressNonZeroPort() {
        WebApp app = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
        int port = app.getListenerAddress().getPort();
        Assert.assertEquals((long)50000L, (long)port);
        WebApp app2 = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
        app.stop();
        app2.stop();
    }

    @Test(expected=WebAppException.class)
    public void testCreateWithNonZeroPort() {
        WebApp app = WebApps.$for((Object)this).at(50000).start();
        int port = app.getListenerAddress().getPort();
        Assert.assertEquals((long)50000L, (long)port);
        WebApp app2 = WebApps.$for((Object)this).at(50000).start();
        app.stop();
        app2.stop();
    }

    @Test
    public void testServePaths() {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        Assert.assertEquals((Object)"/test", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/test", "/test/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assert.assertEquals((long)2L, (long)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    @Test
    public void testServePathsNoName() {
        WebApp app = WebApps.$for((String)"", (Object)this).start();
        Assert.assertEquals((Object)"/", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assert.assertEquals((long)1L, (long)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultRoutes() throws Exception {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        String baseUrl = TestWebApp.baseUrl((WebApp)app);
        try {
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo")).trim());
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo/index")).trim());
            Assert.assertEquals((Object)"bar", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo/bar")).trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent((String)(baseUrl + "test")).trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent((String)(baseUrl + "test/")).trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent((String)baseUrl).trim());
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomRoutes() throws Exception {
        WebApp app = WebApps.$for((String)"test", TestWebApp.class, (Object)this, (String)"ws").start((WebApp)new /* Unavailable Anonymous Inner Class!! */);
        String baseUrl = TestWebApp.baseUrl((WebApp)app);
        try {
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent((String)baseUrl).trim());
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent((String)(baseUrl + "test")).trim());
            Assert.assertEquals((Object)"foo1", (Object)TestWebApp.getContent((String)(baseUrl + "test/1")).trim());
            Assert.assertEquals((Object)"bar", (Object)TestWebApp.getContent((String)(baseUrl + "test/bar/foo")).trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo/bar")).trim());
            Assert.assertEquals((Object)"default1", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo/1")).trim());
            Assert.assertEquals((Object)"default2", (Object)TestWebApp.getContent((String)(baseUrl + "test/foo/bar/2")).trim());
            Assert.assertEquals((long)404L, (long)TestWebApp.getResponseCode((String)(baseUrl + "test/goo")));
            Assert.assertEquals((long)200L, (long)TestWebApp.getResponseCode((String)(baseUrl + "ws/v1/test")));
            Assert.assertTrue((boolean)TestWebApp.getContent((String)(baseUrl + "ws/v1/test")).contains("myInfo"));
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testYARNWebAppContext() throws Exception {
        System.setProperty("hadoop.log.dir", "/Not/Existing/dir");
        WebApp app = WebApps.$for((String)"test", (Object)this).start((WebApp)new /* Unavailable Anonymous Inner Class!! */);
        String baseUrl = TestWebApp.baseUrl((WebApp)app);
        try {
            Assert.assertFalse((boolean)"foo".equals(TestWebApp.getContent((String)(baseUrl + "static")).trim()));
            Assert.assertEquals((long)404L, (long)TestWebApp.getResponseCode((String)(baseUrl + "logs")));
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent((String)baseUrl).trim());
        }
        finally {
            app.stop();
        }
    }

    static String baseUrl(WebApp app) {
        return "http://localhost:" + app.port() + "/";
    }

    static String getContent(String url) {
        try {
            StringBuilder out = new StringBuilder();
            InputStream in = new URL(url).openConnection().getInputStream();
            byte[] buffer = new byte[65536];
            int len = in.read(buffer);
            while (len > 0) {
                out.append(new String(buffer, 0, len));
                len = in.read(buffer);
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int getResponseCode(String url) {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            return c.getResponseCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        WebApps.$for((String)"test", (Object)new TestWebApp()).at(8888).inDevMode().start().joinThread();
    }
}

