/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import junit.framework.Assert;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.junit.Test;

public class TestContainerId {
    @Test
    public void testContainerId() {
        ContainerId c1 = TestContainerId.newContainerId(1, 1, 10L, 1);
        ContainerId c2 = TestContainerId.newContainerId(1, 1, 10L, 2);
        ContainerId c3 = TestContainerId.newContainerId(1, 1, 10L, 1);
        ContainerId c4 = TestContainerId.newContainerId(1, 3, 10L, 1);
        ContainerId c5 = TestContainerId.newContainerId(1, 3, 8L, 1);
        Assert.assertTrue((boolean)c1.equals((Object)c3));
        Assert.assertFalse((boolean)c1.equals((Object)c2));
        Assert.assertFalse((boolean)c1.equals((Object)c4));
        Assert.assertFalse((boolean)c1.equals((Object)c5));
        Assert.assertTrue((c1.compareTo(c3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c1.compareTo(c2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c1.compareTo(c4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c1.compareTo(c5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c1.hashCode() == c3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((c1.hashCode() == c2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((c1.hashCode() == c4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((c1.hashCode() == c5.hashCode() ? 1 : 0) != 0);
        long ts = System.currentTimeMillis();
        ContainerId c6 = TestContainerId.newContainerId(36473, 4365472, ts, 25645811);
        Assert.assertEquals((String)"container_10_0001_01_000001", (String)c1.toString());
        Assert.assertEquals((String)("container_" + ts + "_36473_4365472_25645811"), (String)c6.toString());
    }

    public static ContainerId newContainerId(int appId, int appAttemptId, long timestamp, int containerId) {
        ApplicationId applicationId = ApplicationId.newInstance((long)timestamp, (int)appId);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)appAttemptId);
        return ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)containerId);
    }
}

