/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Resources {
    private static final Resource NONE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Resource UNBOUNDED = new /* Unavailable Anonymous Inner Class!! */;

    public static Resource createResource(int memory) {
        return Resources.createResource((int)memory, (int)(memory > 0 ? 1 : 0));
    }

    public static Resource createResource(int memory, int cores) {
        return Resources.createResource((int)memory, (int)cores, (double)0.0);
    }

    public static Resource createResource(int memory, int cores, double disks) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(memory);
        resource.setVirtualCores(cores);
        resource.setDisks(disks);
        return resource;
    }

    public static Resource none() {
        return NONE;
    }

    public static Resource unbounded() {
        return UNBOUNDED;
    }

    public static Resource clone(Resource res) {
        return Resources.createResource((int)res.getMemory(), (int)res.getVirtualCores(), (double)res.getDisks());
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() + rhs.getMemory());
        lhs.setVirtualCores(lhs.getVirtualCores() + rhs.getVirtualCores());
        lhs.setDisks(lhs.getDisks() + rhs.getDisks());
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo((Resource)Resources.clone((Resource)lhs), (Resource)rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() - rhs.getMemory());
        lhs.setVirtualCores(lhs.getVirtualCores() - rhs.getVirtualCores());
        lhs.setDisks(lhs.getDisks() - rhs.getDisks());
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom((Resource)Resources.clone((Resource)lhs), (Resource)rhs);
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract((Resource)NONE, (Resource)resource);
    }

    public static Resource multiplyTo(Resource lhs, double by) {
        lhs.setMemory((int)((double)lhs.getMemory() * by));
        lhs.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        lhs.setDisks((double)((int)(lhs.getDisks() * by)));
        return lhs;
    }

    public static Resource multiply(Resource lhs, double by) {
        return Resources.multiplyTo((Resource)Resources.clone((Resource)lhs), (double)by);
    }

    public static Resource multiplyAndNormalizeUp(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeUp(lhs, by, factor);
    }

    public static Resource multiplyAndNormalizeDown(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeDown(lhs, by, factor);
    }

    public static Resource multiplyAndRoundDown(Resource lhs, double by) {
        Resource out = Resources.clone((Resource)lhs);
        out.setMemory((int)((double)lhs.getMemory() * by));
        out.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        out.setDisks(lhs.getDisks() * by);
        return out;
    }

    public static Resource normalize(ResourceCalculator calculator, Resource lhs, Resource min, Resource max, Resource increment) {
        return calculator.normalize(lhs, min, max, increment);
    }

    public static Resource roundUp(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundUp(lhs, factor);
    }

    public static Resource roundDown(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundDown(lhs, factor);
    }

    public static float ratio(ResourceCalculator resourceCalculator, Resource lhs, Resource rhs) {
        return resourceCalculator.ratio(lhs, rhs);
    }

    public static float divide(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.divide(clusterResource, lhs, rhs);
    }

    public static Resource divideAndCeil(ResourceCalculator resourceCalculator, Resource lhs, int rhs) {
        return resourceCalculator.divideAndCeil(lhs, rhs);
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.equals((Object)rhs);
    }

    public static boolean lessThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) < 0;
    }

    public static boolean lessThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0;
    }

    public static boolean greaterThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) > 0;
    }

    public static boolean greaterThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0;
    }

    public static Resource min(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0 ? lhs : rhs;
    }

    public static Resource max(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0 ? lhs : rhs;
    }

    public static boolean fitsIn(Resource smaller, Resource bigger) {
        return smaller.getMemory() <= bigger.getMemory() && smaller.getVirtualCores() <= bigger.getVirtualCores() && smaller.getDisks() <= bigger.getDisks();
    }

    public static Resource componentwiseMin(Resource lhs, Resource rhs) {
        return Resources.createResource((int)Math.min(lhs.getMemory(), rhs.getMemory()), (int)Math.min(lhs.getVirtualCores(), rhs.getVirtualCores()), (double)Math.min(lhs.getDisks(), rhs.getDisks()));
    }
}

