/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.client.api.AHSClient;
import org.apache.hadoop.yarn.client.api.impl.TestAHSClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.junit.Test;

public class TestAHSClient {
    @Test
    public void testClientStop() {
        Configuration conf = new Configuration();
        AHSClient client = AHSClient.createAHSClient();
        client.init(conf);
        client.start();
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplications() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        List reports = client.getApplications();
        Assert.assertEquals((Object)reports, (Object)expectedReports);
        reports = client.getApplications();
        Assert.assertEquals((int)reports.size(), (int)4);
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplicationReport() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationReport report = client.getApplicationReport(applicationId);
        Assert.assertEquals((Object)report, expectedReports.get(0));
        Assert.assertEquals((String)report.getApplicationId().toString(), (String)((ApplicationReport)expectedReports.get(0)).getApplicationId().toString());
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplicationAttempts() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        List reports = client.getApplicationAttempts(applicationId);
        Assert.assertNotNull((Object)reports);
        Assert.assertEquals((Object)((ApplicationAttemptReport)reports.get(0)).getApplicationAttemptId(), (Object)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1));
        Assert.assertEquals((Object)((ApplicationAttemptReport)reports.get(1)).getApplicationAttemptId(), (Object)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)2));
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplicationAttempt() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ApplicationAttemptReport report = client.getApplicationAttemptReport(appAttemptId);
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((String)report.getApplicationAttemptId().toString(), (String)((ApplicationReport)expectedReports.get(0)).getCurrentApplicationAttemptId().toString());
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetContainers() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        List reports = client.getContainers(appAttemptId);
        Assert.assertNotNull((Object)reports);
        Assert.assertEquals((Object)((ContainerReport)reports.get(0)).getContainerId(), (Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1));
        Assert.assertEquals((Object)((ContainerReport)reports.get(1)).getContainerId(), (Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)2));
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetContainerReport() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockAHSClient client = new MockAHSClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        ContainerReport report = client.getContainerReport(containerId);
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((String)report.getContainerId().toString(), (String)ContainerId.newInstance((ApplicationAttemptId)((ApplicationReport)expectedReports.get(0)).getCurrentApplicationAttemptId(), (int)1).toString());
        client.stop();
    }
}

