/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMRMClientAsyncImpl<T extends AMRMClient.ContainerRequest>
extends AMRMClientAsync<T> {
    private static final Log LOG = LogFactory.getLog(AMRMClientAsyncImpl.class);
    private final HeartbeatThread heartbeatThread;
    private final CallbackHandlerThread handlerThread;
    private final BlockingQueue<AllocateResponse> responseQueue;
    private final Object unregisterHeartbeatLock = new Object();
    private volatile boolean keepRunning = true;
    private volatile float progress;
    private volatile Throwable savedException = null;

    public AMRMClientAsyncImpl(int intervalMs, AMRMClientAsync.CallbackHandler callbackHandler) {
        this((AMRMClient)new AMRMClientImpl(), intervalMs, callbackHandler);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public AMRMClientAsyncImpl(AMRMClient<T> client, int intervalMs, AMRMClientAsync.CallbackHandler callbackHandler) {
        super(client, intervalMs, callbackHandler);
        this.heartbeatThread = new HeartbeatThread(this);
        this.handlerThread = new CallbackHandlerThread(this);
        this.responseQueue = new LinkedBlockingQueue();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.client.init(conf);
    }

    protected void serviceStart() throws Exception {
        this.handlerThread.setDaemon(true);
        this.handlerThread.start();
        this.client.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.keepRunning = false;
        this.heartbeatThread.interrupt();
        try {
            this.heartbeatThread.join();
        }
        catch (InterruptedException ex) {
            LOG.error((Object)"Error joining with heartbeat thread", (Throwable)ex);
        }
        this.client.stop();
        this.handlerThread.interrupt();
        super.serviceStop();
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatIntervalMs.set(interval);
    }

    public List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        return this.client.getMatchingRequests(priority, resourceName, capability);
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        RegisterApplicationMasterResponse response = this.client.registerApplicationMaster(appHostName, appHostPort, appTrackingUrl);
        this.heartbeatThread.start();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        Object object = this.unregisterHeartbeatLock;
        synchronized (object) {
            this.keepRunning = false;
            this.client.unregisterApplicationMaster(appStatus, appMessage, appTrackingUrl);
        }
    }

    public void addContainerRequest(T req) {
        this.client.addContainerRequest(req);
    }

    public void removeContainerRequest(T req) {
        this.client.removeContainerRequest(req);
    }

    public void releaseAssignedContainer(ContainerId containerId) {
        this.client.releaseAssignedContainer(containerId);
    }

    public Resource getAvailableResources() {
        return this.client.getAvailableResources();
    }

    public int getClusterNodeCount() {
        return this.client.getClusterNodeCount();
    }

    static /* synthetic */ Object access$000(AMRMClientAsyncImpl x0) {
        return x0.unregisterHeartbeatLock;
    }

    static /* synthetic */ boolean access$100(AMRMClientAsyncImpl x0) {
        return x0.keepRunning;
    }

    static /* synthetic */ float access$200(AMRMClientAsyncImpl x0) {
        return x0.progress;
    }

    static /* synthetic */ AMRMClient access$300(AMRMClientAsyncImpl x0) {
        return x0.client;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }

    static /* synthetic */ Throwable access$502(AMRMClientAsyncImpl x0, Throwable x1) {
        x0.savedException = x1;
        return x0.savedException;
    }

    static /* synthetic */ CallbackHandlerThread access$600(AMRMClientAsyncImpl x0) {
        return x0.handlerThread;
    }

    static /* synthetic */ BlockingQueue access$700(AMRMClientAsyncImpl x0) {
        return x0.responseQueue;
    }

    static /* synthetic */ AtomicInteger access$800(AMRMClientAsyncImpl x0) {
        return x0.heartbeatIntervalMs;
    }

    static /* synthetic */ Throwable access$500(AMRMClientAsyncImpl x0) {
        return x0.savedException;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$900(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1000(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1100(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1200(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1300(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ float access$202(AMRMClientAsyncImpl x0, float x1) {
        x0.progress = x1;
        return x0.progress;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1400(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ AMRMClientAsync.CallbackHandler access$1500(AMRMClientAsyncImpl x0) {
        return x0.handler;
    }
}

