/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineClientImpl
extends TimelineClient {
    private static final Log LOG = LogFactory.getLog(TimelineClientImpl.class);
    private static final String RESOURCE_URI_STR = "/ws/v1/timeline/";
    private static final Joiner JOINER = Joiner.on((String)"");
    private Client client;
    private URI resURI;
    private boolean isEnabled;

    public TimelineClientImpl() {
        super(TimelineClientImpl.class.getName());
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        this.client = Client.create((ClientConfig)cc);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.isEnabled = conf.getBoolean("yarn.timeline-service.enabled", false);
        if (!this.isEnabled) {
            LOG.info((Object)"Timeline service is not enabled");
        } else {
            this.resURI = YarnConfiguration.useHttps((Configuration)conf) ? URI.create(JOINER.join((Object)"https://", (Object)conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190"), new Object[]{RESOURCE_URI_STR})) : URI.create(JOINER.join((Object)"http://", (Object)conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188"), new Object[]{RESOURCE_URI_STR}));
            LOG.info((Object)("Timeline service address: " + this.resURI));
        }
        super.serviceInit(conf);
    }

    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        ClientResponse resp;
        if (!this.isEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Nothing will be put because timeline service is not enabled");
            }
            return new TimelinePutResponse();
        }
        TimelineEntities entitiesContainer = new TimelineEntities();
        entitiesContainer.addEntities(Arrays.asList(entities));
        try {
            resp = this.doPostingEntities(entitiesContainer);
        }
        catch (RuntimeException re) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg, (Throwable)re);
            throw re;
        }
        if (resp == null || resp.getClientResponseStatus() != ClientResponse.Status.OK) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error((Object)msg);
            if (LOG.isDebugEnabled() && resp != null) {
                String output = (String)resp.getEntity(String.class);
                LOG.debug((Object)("HTTP error code: " + resp.getStatus() + " Server response : \n" + output));
            }
            throw new YarnException(msg);
        }
        return (TimelinePutResponse)resp.getEntity(TimelinePutResponse.class);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ClientResponse doPostingEntities(TimelineEntities entities) {
        WebResource webResource = this.client.resource(this.resURI);
        return (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
    }
}

