/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.yarn.client.cli.RMAdminCLI;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMAdminCLI {
    private ResourceManagerAdministrationProtocol admin;
    private HAServiceProtocol haadmin;
    private RMAdminCLI rmAdminCLI;
    private RMAdminCLI rmAdminCLIWithHAEnabled;

    @Before
    public void configure() throws IOException {
        this.admin = (ResourceManagerAdministrationProtocol)Mockito.mock(ResourceManagerAdministrationProtocol.class);
        this.haadmin = (HAServiceProtocol)Mockito.mock(HAServiceProtocol.class);
        Mockito.when((Object)this.haadmin.getServiceStatus()).thenReturn((Object)new HAServiceStatus(HAServiceProtocol.HAServiceState.INITIALIZING));
        HAServiceTarget haServiceTarget = (HAServiceTarget)Mockito.mock(HAServiceTarget.class);
        Mockito.when((Object)haServiceTarget.getProxy((Configuration)Matchers.any(Configuration.class), Matchers.anyInt())).thenReturn((Object)this.haadmin);
        this.rmAdminCLI = new /* Unavailable Anonymous Inner Class!! */;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.rmAdminCLIWithHAEnabled = new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test(timeout=500L)
    public void testRefreshQueues() throws Exception {
        String[] args = new String[]{"-refreshQueues"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshQueues((RefreshQueuesRequest)Matchers.any(RefreshQueuesRequest.class));
    }

    @Test(timeout=500L)
    public void testRefreshUserToGroupsMappings() throws Exception {
        String[] args = new String[]{"-refreshUserToGroupsMappings"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshUserToGroupsMappings((RefreshUserToGroupsMappingsRequest)Matchers.any(RefreshUserToGroupsMappingsRequest.class));
    }

    @Test(timeout=500L)
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        String[] args = new String[]{"-refreshSuperUserGroupsConfiguration"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshSuperUserGroupsConfiguration((RefreshSuperUserGroupsConfigurationRequest)Matchers.any(RefreshSuperUserGroupsConfigurationRequest.class));
    }

    @Test(timeout=500L)
    public void testRefreshAdminAcls() throws Exception {
        String[] args = new String[]{"-refreshAdminAcls"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshAdminAcls((RefreshAdminAclsRequest)Matchers.any(RefreshAdminAclsRequest.class));
    }

    @Test(timeout=500L)
    public void testRefreshServiceAcl() throws Exception {
        String[] args = new String[]{"-refreshServiceAcl"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshServiceAcls((RefreshServiceAclsRequest)Matchers.any(RefreshServiceAclsRequest.class));
    }

    @Test(timeout=500L)
    public void testRefreshNodes() throws Exception {
        String[] args = new String[]{"-refreshNodes"};
        Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
        ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshNodes((RefreshNodesRequest)Matchers.any(RefreshNodesRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500L)
    public void testGetGroups() throws Exception {
        Mockito.when((Object)this.admin.getGroupsForUser((String)Matchers.eq((Object)"admin"))).thenReturn((Object)new String[]{"group1", "group2"});
        PrintStream origOut = System.out;
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        System.setOut(out);
        try {
            String[] args = new String[]{"-getGroups", "admin"};
            Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
            ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).getGroupsForUser((String)Matchers.eq((Object)"admin"));
            ((PrintStream)Mockito.verify((Object)out)).println(Matchers.argThat((Matcher)new /* Unavailable Anonymous Inner Class!! */));
        }
        finally {
            System.setOut(origOut);
        }
    }

    @Test(timeout=500L)
    public void testTransitionToActive() throws Exception {
        String[] args = new String[]{"-transitionToActive", "rm1"};
        Assert.assertEquals((long)-1L, (long)this.rmAdminCLI.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin, (VerificationMode)Mockito.never())).transitionToActive((HAServiceProtocol.StateChangeRequestInfo)Matchers.any(HAServiceProtocol.StateChangeRequestInfo.class));
        Assert.assertEquals((long)0L, (long)this.rmAdminCLIWithHAEnabled.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin)).transitionToActive((HAServiceProtocol.StateChangeRequestInfo)Matchers.any(HAServiceProtocol.StateChangeRequestInfo.class));
    }

    @Test(timeout=500L)
    public void testTransitionToStandby() throws Exception {
        String[] args = new String[]{"-transitionToStandby", "rm1"};
        Assert.assertEquals((long)-1L, (long)this.rmAdminCLI.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin, (VerificationMode)Mockito.never())).transitionToStandby((HAServiceProtocol.StateChangeRequestInfo)Matchers.any(HAServiceProtocol.StateChangeRequestInfo.class));
        Assert.assertEquals((long)0L, (long)this.rmAdminCLIWithHAEnabled.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin)).transitionToStandby((HAServiceProtocol.StateChangeRequestInfo)Matchers.any(HAServiceProtocol.StateChangeRequestInfo.class));
    }

    @Test(timeout=500L)
    public void testGetServiceState() throws Exception {
        String[] args = new String[]{"-getServiceState", "rm1"};
        Assert.assertEquals((long)-1L, (long)this.rmAdminCLI.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin, (VerificationMode)Mockito.never())).getServiceStatus();
        Assert.assertEquals((long)0L, (long)this.rmAdminCLIWithHAEnabled.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin)).getServiceStatus();
    }

    @Test(timeout=500L)
    public void testCheckHealth() throws Exception {
        String[] args = new String[]{"-checkHealth", "rm1"};
        Assert.assertEquals((long)-1L, (long)this.rmAdminCLI.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin, (VerificationMode)Mockito.never())).monitorHealth();
        Assert.assertEquals((long)0L, (long)this.rmAdminCLIWithHAEnabled.run(args));
        ((HAServiceProtocol)Mockito.verify((Object)this.haadmin)).monitorHealth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500L)
    public void testHelp() throws Exception {
        PrintStream oldOutPrintStream = System.out;
        PrintStream oldErrPrintStream = System.err;
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        ByteArrayOutputStream dataErr = new ByteArrayOutputStream();
        System.setOut(new PrintStream(dataOut));
        System.setErr(new PrintStream(dataErr));
        try {
            String[] args = new String[]{"-help"};
            Assert.assertEquals((long)0L, (long)this.rmAdminCLI.run(args));
            oldOutPrintStream.println(dataOut);
            Assert.assertTrue((boolean)dataOut.toString().contains("rmadmin is the command to execute YARN administrative commands."));
            Assert.assertTrue((boolean)dataOut.toString().contains("yarn rmadmin [-refreshQueues] [-refreshNodes] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-showLabels] [-refreshLabels] [-refreshServiceAcl] [-getGroup [username]] [-help [cmd]]"));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshQueues: Reload the queues' acls, states and scheduler specific properties."));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshNodes: Refresh the hosts information at the ResourceManager."));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshUserToGroupsMappings: Refresh user-to-groups mappings"));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings"));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshAdminAcls: Refresh acls for administration of ResourceManager"));
            Assert.assertTrue((boolean)dataOut.toString().contains("-refreshServiceAcl: Reload the service-level authorization policy file"));
            Assert.assertTrue((boolean)dataOut.toString().contains("-help [cmd]: Displays help for the given command or all commands if none"));
            this.testError(new String[]{"-help", "-refreshQueues"}, "Usage: yarn rmadmin [-refreshQueues]", dataErr, 0);
            this.testError(new String[]{"-help", "-refreshNodes"}, "Usage: yarn rmadmin [-refreshNodes]", dataErr, 0);
            this.testError(new String[]{"-help", "-refreshUserToGroupsMappings"}, "Usage: yarn rmadmin [-refreshUserToGroupsMappings]", dataErr, 0);
            this.testError(new String[]{"-help", "-refreshSuperUserGroupsConfiguration"}, "Usage: yarn rmadmin [-refreshSuperUserGroupsConfiguration]", dataErr, 0);
            this.testError(new String[]{"-help", "-refreshAdminAcls"}, "Usage: yarn rmadmin [-refreshAdminAcls]", dataErr, 0);
            this.testError(new String[]{"-help", "-refreshServiceAcl"}, "Usage: yarn rmadmin [-refreshServiceAcl]", dataErr, 0);
            this.testError(new String[]{"-help", "-getGroups"}, "Usage: yarn rmadmin [-getGroups [username]]", dataErr, 0);
            this.testError(new String[]{"-help", "-transitionToActive"}, "Usage: yarn rmadmin [-transitionToActive <serviceId>]", dataErr, 0);
            this.testError(new String[]{"-help", "-transitionToStandby"}, "Usage: yarn rmadmin [-transitionToStandby <serviceId>]", dataErr, 0);
            this.testError(new String[]{"-help", "-getServiceState"}, "Usage: yarn rmadmin [-getServiceState <serviceId>]", dataErr, 0);
            this.testError(new String[]{"-help", "-checkHealth"}, "Usage: yarn rmadmin [-checkHealth <serviceId>]", dataErr, 0);
            this.testError(new String[]{"-help", "-failover"}, "Usage: yarn rmadmin [-failover [--forcefence] [--forceactive] <serviceId> <serviceId>]", dataErr, 0);
            this.testError(new String[]{"-help", "-badParameter"}, "Usage: yarn rmadmin", dataErr, 0);
            this.testError(new String[]{"-badParameter"}, "badParameter: Unknown command", dataErr, -1);
            Assert.assertEquals((long)0L, (long)this.rmAdminCLIWithHAEnabled.run(args));
            oldOutPrintStream.println(dataOut);
            Assert.assertTrue((boolean)dataOut.toString().contains("yarn rmadmin [-refreshQueues] [-refreshNodes] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-showLabels] [-refreshLabels] [-refreshServiceAcl] [-getGroup [username]] [-help [cmd]] [-transitionToActive <serviceId>] [-transitionToStandby <serviceId>] [-failover [--forcefence] [--forceactive] <serviceId> <serviceId>] [-getServiceState <serviceId>] [-checkHealth <serviceId>]"));
        }
        finally {
            System.setOut(oldOutPrintStream);
            System.setErr(oldErrPrintStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500L)
    public void testException() throws Exception {
        PrintStream oldErrPrintStream = System.err;
        ByteArrayOutputStream dataErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(dataErr));
        try {
            Mockito.when((Object)this.admin.refreshQueues((RefreshQueuesRequest)Matchers.any(RefreshQueuesRequest.class))).thenThrow(new Throwable[]{new IOException("test exception")});
            String[] args = new String[]{"-refreshQueues"};
            Assert.assertEquals((long)-1L, (long)this.rmAdminCLI.run(args));
            ((ResourceManagerAdministrationProtocol)Mockito.verify((Object)this.admin)).refreshQueues((RefreshQueuesRequest)Matchers.any(RefreshQueuesRequest.class));
            Assert.assertTrue((boolean)dataErr.toString().contains("refreshQueues: test exception"));
        }
        finally {
            System.setErr(oldErrPrintStream);
        }
    }

    private void testError(String[] args, String template, ByteArrayOutputStream data, int resultCode) throws Exception {
        Assert.assertEquals((long)resultCode, (long)this.rmAdminCLI.run(args));
        Assert.assertTrue((boolean)data.toString().contains(template));
        data.reset();
    }

    static /* synthetic */ ResourceManagerAdministrationProtocol access$000(TestRMAdminCLI x0) {
        return x0.admin;
    }
}

