/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.api.impl.TestYarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationIdNotProvidedException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestYarnClient {
    @Test
    public void test() {
    }

    @Test
    public void testClientStop() {
        Configuration conf = new Configuration();
        ResourceManager rm = new ResourceManager();
        rm.init(conf);
        rm.start();
        YarnClient client = YarnClient.createYarnClient();
        client.init(conf);
        client.start();
        client.stop();
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testSubmitApplication() {
        Configuration conf = new Configuration();
        conf.setLong("yarn.client.app-submission.poll-interval", 100L);
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        YarnApplicationState[] exitStates = new YarnApplicationState[]{YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING, YarnApplicationState.FINISHED, YarnApplicationState.FAILED, YarnApplicationState.KILLED};
        ApplicationSubmissionContext contextWithoutApplicationId = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        try {
            client.submitApplication(contextWithoutApplicationId);
            Assert.fail((String)"Should throw the ApplicationIdNotProvidedException");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)(e instanceof ApplicationIdNotProvidedException));
            Assert.assertTrue((boolean)e.getMessage().contains("ApplicationId is not provided in ApplicationSubmissionContext"));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException is not expected.");
        }
        for (int i = 0; i < exitStates.length; ++i) {
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
            ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)i);
            Mockito.when((Object)context.getApplicationId()).thenReturn((Object)applicationId);
            client.setYarnApplicationState(exitStates[i]);
            try {
                client.submitApplication(context);
            }
            catch (YarnException e) {
                Assert.fail((String)"Exception is not expected.");
            }
            catch (IOException e) {
                Assert.fail((String)"Exception is not expected.");
            }
            ((ApplicationReport)Mockito.verify((Object)MockYarnClient.access$000((MockYarnClient)client), (VerificationMode)Mockito.times((int)(4 * i + 4)))).getYarnApplicationState();
        }
        client.stop();
    }

    @Test
    public void testKillApplication() throws Exception {
        MockRM rm = new MockRM();
        rm.start();
        RMApp app = rm.submitApp(2000);
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        client.killApplication(app.getApplicationId());
        ((ApplicationClientProtocol)Mockito.verify((Object)client.getRMClient(), (VerificationMode)Mockito.times((int)2))).forceKillApplication((KillApplicationRequest)Matchers.any(KillApplicationRequest.class));
    }

    @Test(timeout=30000L)
    public void testApplicationType() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        RMApp app = rm.submitApp(2000);
        RMApp app1 = rm.submitApp(200, "name", "user", new HashMap(), false, "default", -1, null, "MAPREDUCE");
        Assert.assertEquals((String)"YARN", (String)app.getApplicationType());
        Assert.assertEquals((String)"MAPREDUCE", (String)app1.getApplicationType());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testApplicationTypeLimit() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        RMApp app1 = rm.submitApp(200, "name", "user", new HashMap(), false, "default", -1, null, "MAPREDUCE-LENGTH-IS-20");
        Assert.assertEquals((String)"MAPREDUCE-LENGTH-IS-", (String)app1.getApplicationType());
        rm.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplications() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        List reports = client.getApplications();
        Assert.assertEquals((Object)reports, (Object)expectedReports);
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("YARN");
        appTypes.add("NON-YARN");
        reports = client.getApplications(appTypes, null);
        Assert.assertEquals((int)reports.size(), (int)2);
        Assert.assertTrue((((ApplicationReport)reports.get(0)).getApplicationType().equals("YARN") && ((ApplicationReport)reports.get(1)).getApplicationType().equals("NON-YARN") || ((ApplicationReport)reports.get(1)).getApplicationType().equals("YARN") && ((ApplicationReport)reports.get(0)).getApplicationType().equals("NON-YARN") ? 1 : 0) != 0);
        for (ApplicationReport report : reports) {
            Assert.assertTrue((boolean)expectedReports.contains(report));
        }
        EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
        appStates.add(YarnApplicationState.FINISHED);
        appStates.add(YarnApplicationState.FAILED);
        reports = client.getApplications(null, appStates);
        Assert.assertEquals((int)reports.size(), (int)2);
        Assert.assertTrue((((ApplicationReport)reports.get(0)).getApplicationType().equals("NON-YARN") && ((ApplicationReport)reports.get(1)).getApplicationType().equals("NON-MAPREDUCE") || ((ApplicationReport)reports.get(1)).getApplicationType().equals("NON-YARN") && ((ApplicationReport)reports.get(0)).getApplicationType().equals("NON-MAPREDUCE") ? 1 : 0) != 0);
        for (ApplicationReport report : reports) {
            Assert.assertTrue((boolean)expectedReports.contains(report));
        }
        reports = client.getApplications(appTypes, appStates);
        Assert.assertEquals((int)reports.size(), (int)1);
        Assert.assertTrue((boolean)((ApplicationReport)reports.get(0)).getApplicationType().equals("NON-YARN"));
        for (ApplicationReport report : reports) {
            Assert.assertTrue((boolean)expectedReports.contains(report));
        }
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplicationAttempts() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        List reports = client.getApplicationAttempts(applicationId);
        Assert.assertNotNull((Object)reports);
        Assert.assertEquals((Object)((ApplicationAttemptReport)reports.get(0)).getApplicationAttemptId(), (Object)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1));
        Assert.assertEquals((Object)((ApplicationAttemptReport)reports.get(1)).getApplicationAttemptId(), (Object)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)2));
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetApplicationAttempt() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ApplicationAttemptReport report = client.getApplicationAttemptReport(appAttemptId);
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((String)report.getApplicationAttemptId().toString(), (String)((ApplicationReport)expectedReports.get(0)).getCurrentApplicationAttemptId().toString());
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetContainers() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        List reports = client.getContainers(appAttemptId);
        Assert.assertNotNull((Object)reports);
        Assert.assertEquals((Object)((ContainerReport)reports.get(0)).getContainerId(), (Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1));
        Assert.assertEquals((Object)((ContainerReport)reports.get(1)).getContainerId(), (Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)2));
        client.stop();
    }

    @Test(timeout=10000L)
    public void testGetContainerReport() throws YarnException, IOException {
        Configuration conf = new Configuration();
        MockYarnClient client = new MockYarnClient();
        client.init(conf);
        client.start();
        List expectedReports = client.getReports();
        ApplicationId applicationId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        ContainerReport report = client.getContainerReport(containerId);
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((String)report.getContainerId().toString(), (String)ContainerId.newInstance((ApplicationAttemptId)((ApplicationReport)expectedReports.get(0)).getCurrentApplicationAttemptId(), (int)1).toString());
        client.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAMMRTokens() throws Exception {
        MiniYARNCluster cluster = new MiniYARNCluster("testMRAMTokens", 1, 1, 1);
        YarnClient rmClient = null;
        try {
            cluster.init((Configuration)new YarnConfiguration());
            cluster.start();
            Configuration yarnConf = cluster.getConfig();
            rmClient = YarnClient.createYarnClient();
            rmClient.init(yarnConf);
            rmClient.start();
            ApplicationId appId = this.createApp(rmClient, false);
            this.waitTillAccepted(rmClient, appId);
            Assert.assertNull((Object)rmClient.getAMRMToken(appId));
            appId = this.createApp(rmClient, true);
            this.waitTillAccepted(rmClient, appId);
            long start = System.currentTimeMillis();
            while (rmClient.getAMRMToken(appId) == null) {
                if (System.currentTimeMillis() - start > 20000L) {
                    Assert.fail((String)"AMRM token is null");
                }
                Thread.sleep(100L);
            }
            Assert.assertNotNull((Object)rmClient.getAMRMToken(appId));
            UserGroupInformation other = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[0]);
            appId = (ApplicationId)other.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            Assert.assertNull((Object)rmClient.getAMRMToken(appId));
        }
        finally {
            if (rmClient != null) {
                rmClient.stop();
            }
            cluster.stop();
        }
    }

    private ApplicationId createApp(YarnClient rmClient, boolean unmanaged) throws Exception {
        YarnClientApplication newApp = rmClient.createApplication();
        ApplicationId appId = newApp.getNewApplicationResponse().getApplicationId();
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationId(appId);
        appContext.setApplicationName("test");
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(1);
        appContext.setPriority(pri);
        appContext.setQueue("default");
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appContext.setAMContainerSpec(amContainer);
        appContext.setResource(Resource.newInstance((int)1024, (int)1));
        appContext.setUnmanagedAM(unmanaged);
        rmClient.submitApplication(appContext);
        return appId;
    }

    private void waitTillAccepted(YarnClient rmClient, ApplicationId appId) throws Exception {
        try {
            long start = System.currentTimeMillis();
            ApplicationReport report = rmClient.getApplicationReport(appId);
            while (YarnApplicationState.ACCEPTED != report.getYarnApplicationState()) {
                if (System.currentTimeMillis() - start > 20000L) {
                    throw new Exception("App '" + appId + "' time out, failed to reach ACCEPTED state");
                }
                Thread.sleep(200L);
                report = rmClient.getApplicationReport(appId);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testAsyncAPIPollTimeout() {
        this.testAsyncAPIPollTimeoutHelper(null, false);
        this.testAsyncAPIPollTimeoutHelper(Long.valueOf(0L), true);
        this.testAsyncAPIPollTimeoutHelper(Long.valueOf(1L), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAsyncAPIPollTimeoutHelper(Long valueForTimeout, boolean expectedTimeoutEnforcement) {
        YarnClientImpl client = new YarnClientImpl();
        try {
            Configuration conf = new Configuration();
            if (valueForTimeout != null) {
                conf.setLong("yarn.client.application-client-protocol.poll-timeout-ms", valueForTimeout.longValue());
            }
            client.init(conf);
            Assert.assertEquals((boolean)expectedTimeoutEnforcement, (boolean)client.enforceAsyncAPITimeout());
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    static /* synthetic */ ApplicationId access$100(TestYarnClient x0, YarnClient x1, boolean x2) throws Exception {
        return x0.createApp(x1, x2);
    }

    static /* synthetic */ void access$200(TestYarnClient x0, YarnClient x1, ApplicationId x2) throws Exception {
        x0.waitTillAccepted(x1, x2);
    }
}

