/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ProtocolHATestBase;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.ServerRMProxy;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestResourceTrackerOnHA
extends ProtocolHATestBase {
    private ResourceTracker resourceTracker = null;

    @Before
    public void initiate() throws Exception {
        this.startHACluster(0, false, true, false);
        this.resourceTracker = this.getRMClient();
    }

    @After
    public void shutDown() {
        if (this.resourceTracker != null) {
            RPC.stopProxy((Object)this.resourceTracker);
        }
    }

    @Test(timeout=15000L)
    public void testResourceTrackerOnHA() throws Exception {
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)0);
        Resource resource = Resource.newInstance((int)2048, (int)4);
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)nodeId, (int)0, (Resource)resource, (String)YarnVersionInfo.getVersion(), null);
        this.resourceTracker.registerNodeManager(request);
        Assert.assertTrue((boolean)this.waitForNodeManagerToConnect(10000, nodeId));
        this.failoverThread = this.createAndStartFailoverThread();
        NodeStatus status = NodeStatus.newInstance((NodeId)NodeId.newInstance((String)"localhost", (int)0), (int)0, null, null, null);
        NodeHeartbeatRequest request2 = NodeHeartbeatRequest.newInstance((NodeStatus)status, null, null);
        this.resourceTracker.nodeHeartbeat(request2);
    }

    private ResourceTracker getRMClient() throws IOException {
        return (ResourceTracker)ServerRMProxy.createRMProxy((Configuration)this.conf, ResourceTracker.class);
    }

    private boolean waitForNodeManagerToConnect(int timeout, NodeId nodeId) throws Exception {
        for (int i = 0; i < timeout / 100; ++i) {
            if (this.getActiveRM().getRMContext().getRMNodes().containsKey(nodeId)) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }
}

