/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.client.api.impl.NMClientImpl;
import org.apache.hadoop.yarn.client.api.impl.TestAMRMClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNMClient {
    Configuration conf = null;
    MiniYARNCluster yarnCluster = null;
    YarnClientImpl yarnClient = null;
    AMRMClientImpl<AMRMClient.ContainerRequest> rmClient = null;
    NMClientImpl nmClient = null;
    List<NodeReport> nodeReports = null;
    ApplicationAttemptId attemptId = null;
    int nodeCount = 3;
    NMTokenCache nmTokenCache = null;

    @Before
    public void setup() throws YarnException, IOException {
        int iterationsLeft;
        this.conf = new YarnConfiguration();
        this.yarnCluster = new MiniYARNCluster(TestAMRMClient.class.getName(), this.nodeCount, 1, 1);
        this.yarnCluster.init(this.conf);
        this.yarnCluster.start();
        Assert.assertNotNull((Object)this.yarnCluster);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.yarnCluster.getServiceState());
        this.yarnClient = (YarnClientImpl)YarnClient.createYarnClient();
        this.yarnClient.init(this.conf);
        this.yarnClient.start();
        Assert.assertNotNull((Object)this.yarnClient);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.yarnClient.getServiceState());
        this.nodeReports = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        ApplicationSubmissionContext appContext = this.yarnClient.createApplication().getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        appContext.setApplicationName("Test");
        Priority pri = Priority.newInstance((int)0);
        appContext.setPriority(pri);
        appContext.setQueue("default");
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appContext.setAMContainerSpec(amContainer);
        appContext.setUnmanagedAM(true);
        SubmitApplicationRequest appRequest = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        appRequest.setApplicationSubmissionContext(appContext);
        this.yarnClient.submitApplication(appContext);
        RMAppAttempt appAttempt = null;
        for (iterationsLeft = 30; iterationsLeft > 0; --iterationsLeft) {
            ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
            if (appReport.getYarnApplicationState() == YarnApplicationState.ACCEPTED) {
                this.attemptId = appReport.getCurrentApplicationAttemptId();
                appAttempt = ((RMApp)this.yarnCluster.getResourceManager().getRMContext().getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
                while (appAttempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED) {
                }
                break;
            }
            this.sleep(1000);
        }
        if (iterationsLeft == 0) {
            Assert.fail((String)"Application hasn't bee started");
        }
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName()));
        UserGroupInformation.getCurrentUser().addToken(appAttempt.getAMRMToken());
        this.nmTokenCache = new NMTokenCache();
        this.rmClient = (AMRMClientImpl)AMRMClient.createAMRMClient();
        this.rmClient.setNMTokenCache(this.nmTokenCache);
        this.rmClient.init(this.conf);
        this.rmClient.start();
        Assert.assertNotNull((Object)this.rmClient);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.rmClient.getServiceState());
        this.nmClient = (NMClientImpl)NMClient.createNMClient();
        this.nmClient.setNMTokenCache(this.rmClient.getNMTokenCache());
        this.nmClient.init(this.conf);
        this.nmClient.start();
        Assert.assertNotNull((Object)this.nmClient);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.nmClient.getServiceState());
    }

    @After
    public void tearDown() {
        this.rmClient.stop();
        this.yarnClient.stop();
        this.yarnCluster.stop();
    }

    private void stopNmClient(boolean stopContainers) {
        Assert.assertNotNull((String)"Null nmClient", (Object)this.nmClient);
        Assert.assertEquals((long)1L, (long)this.nmClient.startedContainers.size());
        Assert.assertTrue((boolean)this.nmClient.getCleanupRunningContainers().get());
        this.nmClient.cleanupRunningContainersOnStop(stopContainers);
        Assert.assertEquals((Object)stopContainers, (Object)this.nmClient.getCleanupRunningContainers().get());
        this.nmClient.stop();
    }

    @Test(timeout=180000L)
    public void testNMClientNoCleanupOnStop() throws YarnException, IOException {
        this.rmClient.registerApplicationMaster("Host", 10000, "");
        this.testContainerManagement(this.nmClient, this.allocateContainers(this.rmClient, 5));
        this.rmClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        this.stopNmClient(false);
        Assert.assertFalse((boolean)this.nmClient.startedContainers.isEmpty());
        this.nmClient.cleanupRunningContainers();
        Assert.assertEquals((long)0L, (long)this.nmClient.startedContainers.size());
    }

    @Test(timeout=200000L)
    public void testNMClient() throws YarnException, IOException {
        this.rmClient.registerApplicationMaster("Host", 10000, "");
        this.testContainerManagement(this.nmClient, this.allocateContainers(this.rmClient, 5));
        this.rmClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, null);
        Assert.assertFalse((boolean)this.nmClient.startedContainers.isEmpty());
        this.nmClient.cleanupRunningContainersOnStop(true);
        Assert.assertTrue((boolean)this.nmClient.getCleanupRunningContainers().get());
        this.nmClient.stop();
    }

    private Set<Container> allocateContainers(AMRMClientImpl<AMRMClient.ContainerRequest> rmClient, int num) throws YarnException, IOException {
        Resource capability = Resource.newInstance((int)1024, (int)0);
        Priority priority = Priority.newInstance((int)0);
        String node = ((NodeReport)this.nodeReports.get(0)).getNodeId().getHost();
        String rack = ((NodeReport)this.nodeReports.get(0)).getRackName();
        String[] nodes = new String[]{node};
        String[] racks = new String[]{rack};
        for (int i = 0; i < num; ++i) {
            rmClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, nodes, racks, priority));
        }
        int containersRequestedAny = ((AMRMClientImpl.ResourceRequestInfo)((TreeMap)((Map)rmClient.remoteRequestsTable.get((Object)priority)).get((Object)"*")).get((Object)capability)).remoteRequest.getNumContainers();
        int allocatedContainerCount = 0;
        TreeSet<Container> containers = new TreeSet<Container>();
        for (int iterationsLeft = 2; allocatedContainerCount < containersRequestedAny && iterationsLeft > 0; --iterationsLeft) {
            AllocateResponse allocResponse = rmClient.allocate(0.1f);
            allocatedContainerCount += allocResponse.getAllocatedContainers().size();
            for (Container container : allocResponse.getAllocatedContainers()) {
                containers.add(container);
            }
            if (!allocResponse.getNMTokens().isEmpty()) {
                for (NMToken token : allocResponse.getNMTokens()) {
                    rmClient.getNMTokenCache().setToken(token.getNodeId().toString(), token.getToken());
                }
            }
            if (allocatedContainerCount >= containersRequestedAny) continue;
            this.sleep(1000);
        }
        return containers;
    }

    private void testContainerManagement(NMClientImpl nmClient, Set<Container> containers) throws YarnException, IOException {
        int size = containers.size();
        int i = 0;
        for (Container container : containers) {
            block11: {
                try {
                    nmClient.getContainerStatus(container.getId(), container.getNodeId());
                    Assert.fail((String)"Exception is expected");
                }
                catch (YarnException e) {
                    Assert.assertTrue((String)"The thrown exception is not expected", (boolean)e.getMessage().contains("is not handled by this NodeManager"));
                }
                try {
                    nmClient.stopContainer(container.getId(), container.getNodeId());
                    Assert.fail((String)"Exception is expected");
                }
                catch (YarnException e) {
                    if (e.getMessage().contains("is not handled by this NodeManager")) break block11;
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Exception is not expected: " + (Object)((Object)e))))).initCause(e));
                }
            }
            Credentials ts = new Credentials();
            DataOutputBuffer dob = new DataOutputBuffer();
            ts.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            clc.setTokens(securityTokens);
            try {
                nmClient.startContainer(container, clc);
            }
            catch (YarnException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Exception is not expected: " + (Object)((Object)e))))).initCause(e));
            }
            if (++i >= size) continue;
            this.testGetContainerStatus(container, i, ContainerState.RUNNING, "", Arrays.asList(-1000));
            try {
                nmClient.stopContainer(container.getId(), container.getNodeId());
            }
            catch (YarnException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Exception is not expected: " + (Object)((Object)e))))).initCause(e));
            }
            try {
                this.testGetContainerStatus(container, i, ContainerState.COMPLETE, "Container killed by the ApplicationMaster.", Arrays.asList(137, 143, 0));
            }
            catch (YarnException e) {
                if (e.getMessage().contains("was recently stopped on node manager")) continue;
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Exception is not expected: " + (Object)((Object)e))))).initCause(e));
            }
        }
    }

    private void sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void testGetContainerStatus(Container container, int index, ContainerState state, String diagnostics, List<Integer> exitStatuses) throws YarnException, IOException {
        block2: while (true) {
            try {
                while (true) {
                    ContainerStatus status;
                    if ((status = this.nmClient.getContainerStatus(container.getId(), container.getNodeId())).getState() == state) {
                        Assert.assertEquals((Object)container.getId(), (Object)status.getContainerId());
                        Assert.assertTrue((String)("" + index + ": " + status.getDiagnostics()), (boolean)status.getDiagnostics().contains(diagnostics));
                        Assert.assertTrue((boolean)exitStatuses.contains(status.getExitStatus()));
                        break block2;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

