/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.unmanagedamlauncher;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.applications.unmanagedamlauncher.TestUnmanagedAMLauncher;
import org.apache.hadoop.yarn.applications.unmanagedamlauncher.UnmanagedAMLauncher;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestUnmanagedAMLauncher {
    private static final Log LOG = LogFactory.getLog(TestUnmanagedAMLauncher.class);
    protected static MiniYARNCluster yarnCluster = null;
    protected static Configuration conf = new Configuration();

    @BeforeClass
    public static void setup() throws InterruptedException, IOException {
        LOG.info((Object)"Starting up YARN cluster");
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
        if (yarnCluster == null) {
            yarnCluster = new MiniYARNCluster(TestUnmanagedAMLauncher.class.getSimpleName(), 1, 1, 1);
            yarnCluster.init(conf);
            yarnCluster.start();
            Configuration yarnClusterConfig = yarnCluster.getConfig();
            LOG.info((Object)("MiniYARN ResourceManager published address: " + yarnClusterConfig.get("yarn.resourcemanager.address")));
            LOG.info((Object)("MiniYARN ResourceManager published web address: " + yarnClusterConfig.get("yarn.resourcemanager.webapp.address")));
            String webapp = yarnClusterConfig.get("yarn.resourcemanager.webapp.address");
            Assert.assertTrue((String)("Web app address still unbound to a host at " + webapp), (!webapp.startsWith("0.0.0.0") ? 1 : 0) != 0);
            LOG.info((Object)("Yarn webapp is at " + webapp));
            URL url = Thread.currentThread().getContextClassLoader().getResource("yarn-site.xml");
            if (url == null) {
                throw new RuntimeException("Could not find 'yarn-site.xml' dummy file in classpath");
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            yarnClusterConfig.writeXml((OutputStream)bytesOut);
            bytesOut.close();
            FileOutputStream os = new FileOutputStream(new File(url.getPath()));
            ((OutputStream)os).write(bytesOut.toByteArray());
            ((OutputStream)os).close();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("setup thread sleep interrupted. message=" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDown() throws IOException {
        if (yarnCluster != null) {
            try {
                yarnCluster.stop();
            }
            finally {
                yarnCluster = null;
            }
        }
    }

    private static String getTestRuntimeClasspath() {
        LOG.info((Object)"Trying to generate classpath for app master from current thread's classpath");
        String envClassPath = "";
        String cp = System.getProperty("java.class.path");
        if (cp != null) {
            envClassPath = envClassPath + cp.trim() + File.pathSeparator;
        }
        ClassLoader thisClassLoader = Thread.currentThread().getContextClassLoader();
        URL url = thisClassLoader.getResource("yarn-site.xml");
        envClassPath = envClassPath + new File(url.getFile()).getParent();
        return envClassPath;
    }

    @Test(timeout=30000L)
    public void testUMALauncher() throws Exception {
        String classpath = TestUnmanagedAMLauncher.getTestRuntimeClasspath();
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            LOG.fatal((Object)"JAVA_HOME not defined. Test not running.");
            return;
        }
        String[] args = new String[]{"--classpath", classpath, "--queue", "default", "--cmd", javaHome + "/bin/java -Xmx512m " + TestUnmanagedAMLauncher.class.getCanonicalName() + " success"};
        LOG.info((Object)"Initializing Launcher");
        1 launcher = new /* Unavailable Anonymous Inner Class!! */;
        boolean initSuccess = launcher.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running Launcher");
        boolean result = launcher.run();
        LOG.info((Object)("Launcher run completed. Result=" + result));
        Assert.assertTrue((boolean)result);
    }

    @Test(timeout=30000L)
    public void testUMALauncherError() throws Exception {
        String classpath = TestUnmanagedAMLauncher.getTestRuntimeClasspath();
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            LOG.fatal((Object)"JAVA_HOME not defined. Test not running.");
            return;
        }
        String[] args = new String[]{"--classpath", classpath, "--queue", "default", "--cmd", javaHome + "/bin/java -Xmx512m " + TestUnmanagedAMLauncher.class.getCanonicalName() + " failure"};
        LOG.info((Object)"Initializing Launcher");
        UnmanagedAMLauncher launcher = new UnmanagedAMLauncher(new Configuration(yarnCluster.getConfig()));
        boolean initSuccess = launcher.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running Launcher");
        try {
            launcher.run();
            Assert.fail((String)"Expected an exception to occur as launch should have failed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equals("success")) {
            ApplicationMasterProtocol client = (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationMasterProtocol.class);
            client.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance((String)NetUtils.getHostname(), (int)-1, (String)""));
            Thread.sleep(1000L);
            FinishApplicationMasterResponse resp = client.finishApplicationMaster(FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"success", null));
            Assert.assertTrue((boolean)resp.getIsUnregistered());
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

