/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.applications.distributedshell.ContainerLaunchFailAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDSFailedAppMaster;
import org.apache.hadoop.yarn.applications.distributedshell.TestDistributedShell;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistributedShell {
    private static final Log LOG = LogFactory.getLog(TestDistributedShell.class);
    protected MiniYARNCluster yarnCluster = null;
    protected Configuration conf = new YarnConfiguration();
    protected static final String APPMASTER_JAR = JarFinder.getJar(ApplicationMaster.class);

    @Before
    public void setup() throws Exception {
        LOG.info((Object)"Starting up YARN cluster");
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.log.dir", "target");
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        if (this.yarnCluster == null) {
            this.yarnCluster = new MiniYARNCluster(TestDistributedShell.class.getSimpleName(), 1, 1, 1, 1, true);
            this.yarnCluster.init(this.conf);
            this.yarnCluster.start();
            NodeManager nm = this.yarnCluster.getNodeManager(0);
            TestDistributedShell.waitForNMToRegister((NodeManager)nm);
            URL url = Thread.currentThread().getContextClassLoader().getResource("yarn-site.xml");
            if (url == null) {
                throw new RuntimeException("Could not find 'yarn-site.xml' dummy file in classpath");
            }
            Configuration yarnClusterConfig = this.yarnCluster.getConfig();
            yarnClusterConfig.set("yarn.application.classpath", new File(url.getPath()).getParent());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            yarnClusterConfig.writeXml((OutputStream)bytesOut);
            bytesOut.close();
            FileOutputStream os = new FileOutputStream(new File(url.getPath()));
            ((OutputStream)os).write(bytesOut.toByteArray());
            ((OutputStream)os).close();
        }
        FileContext fsContext = FileContext.getLocalFSFileContext();
        fsContext.delete(new Path(this.conf.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("setup thread sleep interrupted. message=" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        if (this.yarnCluster != null) {
            try {
                this.yarnCluster.stop();
            }
            finally {
                this.yarnCluster = null;
            }
        }
        FileContext fsContext = FileContext.getLocalFSFileContext();
        fsContext.delete(new Path(this.conf.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
    }

    @Test(timeout=90000L)
    public void testDSShell() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        AtomicBoolean result = new AtomicBoolean(false);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(new Configuration(this.yarnCluster.getConfig()));
        yarnClient.start();
        String hostName = NetUtils.getHostname();
        boolean verified = false;
        while (!verified) {
            List apps = yarnClient.getApplications();
            if (apps.size() == 0) {
                Thread.sleep(10L);
                continue;
            }
            ApplicationReport appReport = (ApplicationReport)apps.get(0);
            if (appReport.getHost().startsWith(hostName) && appReport.getRpcPort() == -1) {
                verified = true;
            }
            if (appReport.getYarnApplicationState() != YarnApplicationState.FINISHED) continue;
            break;
        }
        Assert.assertTrue((boolean)verified);
        t.join();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((boolean)result.get());
        TimelineEntities entitiesAttempts = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getEntities(ApplicationMaster.DSEntity.DS_APP_ATTEMPT.toString(), null, null, null, null, null, null, null, null);
        Assert.assertNotNull((Object)entitiesAttempts);
        Assert.assertEquals((long)1L, (long)entitiesAttempts.getEntities().size());
        Assert.assertEquals((long)2L, (long)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getEvents().size());
        Assert.assertEquals((Object)((TimelineEntity)entitiesAttempts.getEntities().get(0)).getEntityType().toString(), (Object)ApplicationMaster.DSEntity.DS_APP_ATTEMPT.toString());
        TimelineEntities entities = this.yarnCluster.getApplicationHistoryServer().getTimelineStore().getEntities(ApplicationMaster.DSEntity.DS_CONTAINER.toString(), null, null, null, null, null, null, null, null);
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        Assert.assertEquals((Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType().toString(), (Object)ApplicationMaster.DSEntity.DS_CONTAINER.toString());
    }

    @Test(timeout=90000L)
    public void testDSRestartWithPreviousRunningContainers() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_command", "sleep 8", "--master_memory", "512", "--container_memory", "128", "--keep_containers_across_application_attempts"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(TestDSFailedAppMaster.class.getName(), new Configuration(this.yarnCluster.getConfig()));
        client.init(args);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((boolean)result);
    }

    @Test(timeout=90000L)
    public void testDSShellWithCustomLogPropertyFile() throws Exception {
        File basedir = new File("target", TestDistributedShell.class.getName());
        File tmpDir = new File(basedir, "tmpDir");
        tmpDir.mkdirs();
        File customLogProperty = new File(tmpDir, "custom_log4j.properties");
        if (customLogProperty.exists()) {
            customLogProperty.delete();
        }
        if (!customLogProperty.createNewFile()) {
            Assert.fail((String)"Can not create custom log4j property file.");
        }
        PrintWriter fileWriter = new PrintWriter(customLogProperty);
        fileWriter.write("log4j.rootLogger=debug,stdout");
        fileWriter.close();
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "3", "--shell_command", "echo", "--shell_args", "HADOOP", "--log_properties", customLogProperty.getAbsolutePath(), "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        Log LOG_Client = LogFactory.getLog(Client.class);
        Assert.assertTrue((boolean)LOG_Client.isInfoEnabled());
        Assert.assertFalse((boolean)LOG_Client.isDebugEnabled());
        Log LOG_AM = LogFactory.getLog(ApplicationMaster.class);
        Assert.assertTrue((boolean)LOG_AM.isInfoEnabled());
        Assert.assertFalse((boolean)LOG_AM.isDebugEnabled());
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertTrue((this.verifyContainerLog(3, null, true, "DEBUG") > 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LOG_Client.isInfoEnabled());
        Assert.assertTrue((boolean)LOG_Client.isDebugEnabled());
        Assert.assertTrue((boolean)LOG_AM.isInfoEnabled());
        Assert.assertTrue((boolean)LOG_AM.isDebugEnabled());
    }

    public void testDSShellWithCommands() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", "\"echo output_ignored;echo output_expected\"", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("output_expected");
        this.verifyContainerLog(2, expectedContent, false, "");
    }

    @Test(timeout=90000L)
    public void testDSShellWithMultipleArgs() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "4", "--shell_command", "echo", "--shell_args", "HADOOP YARN MAPREDUCE HDFS", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("HADOOP YARN MAPREDUCE HDFS");
        this.verifyContainerLog(4, expectedContent, false, "");
    }

    @Test(timeout=90000L)
    public void testDSShellWithShellScript() throws Exception {
        File basedir = new File("target", TestDistributedShell.class.getName());
        File tmpDir = new File(basedir, "tmpDir");
        tmpDir.mkdirs();
        File customShellScript = new File(tmpDir, "custom_script.sh");
        if (customShellScript.exists()) {
            customShellScript.delete();
        }
        if (!customShellScript.createNewFile()) {
            Assert.fail((String)"Can not create custom shell script file.");
        }
        PrintWriter fileWriter = new PrintWriter(customShellScript);
        fileWriter.write("echo testDSShellWithShellScript");
        fileWriter.close();
        System.out.println(customShellScript.getAbsolutePath());
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "1", "--shell_script", customShellScript.getAbsolutePath(), "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        ArrayList<String> expectedContent = new ArrayList<String>();
        expectedContent.add("testDSShellWithShellScript");
        this.verifyContainerLog(1, expectedContent, false, "");
    }

    @Test(timeout=90000L)
    public void testDSShellWithInvalidArgs() throws Exception {
        String[] args;
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        LOG.info((Object)"Initializing DS Client with no args");
        try {
            client.init(new String[0]);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No args"));
        }
        LOG.info((Object)"Initializing DS Client with no jar file");
        try {
            args = new String[]{"--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No jar"));
        }
        LOG.info((Object)"Initializing DS Client with no shell command");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No shell command"));
        }
        LOG.info((Object)"Initializing DS Client with invalid no. of containers");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "-1", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Invalid no. of containers"));
        }
        LOG.info((Object)"Initializing DS Client with invalid no. of vcores");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "-2", "--container_memory", "128", "--container_vcores", "1"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Invalid virtual cores specified"));
        }
        LOG.info((Object)"Initializing DS Client with --shell_command and --shell_script");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1", "--shell_script", "test.sh"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("Can not specify shell_command option and shell_script option at the same time"));
        }
        LOG.info((Object)"Initializing DS Client without --shell_command and --shell_script");
        try {
            args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1"};
            client.init(args);
            Assert.fail((String)"Exception is expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"The throw exception is not expected", (boolean)e.getMessage().contains("No shell command or shell script specified to be executed by application master"));
        }
    }

    protected static void waitForNMToRegister(NodeManager nm) throws Exception {
        int attempt = 60;
        ContainerManagerImpl cm = (ContainerManagerImpl)nm.getNMContext().getContainerManager();
        while (cm.getBlockNewContainerRequestsStatus() && attempt-- > 0) {
            Thread.sleep(2000L);
        }
    }

    @Test(timeout=90000L)
    public void testContainerLaunchFailureHandling() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--container_memory", "128"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(ContainerLaunchFailAppMaster.class.getName(), new Configuration(this.yarnCluster.getConfig()));
        boolean initSuccess = client.init(args);
        Assert.assertTrue((boolean)initSuccess);
        LOG.info((Object)"Running DS Client");
        boolean result = client.run();
        LOG.info((Object)("Client run completed. Result=" + result));
        Assert.assertFalse((boolean)result);
    }

    @Test(timeout=90000L)
    public void testDebugFlag() throws Exception {
        String[] args = new String[]{"--jar", APPMASTER_JAR, "--num_containers", "2", "--shell_command", Shell.WINDOWS ? "dir" : "ls", "--master_memory", "512", "--master_vcores", "2", "--container_memory", "128", "--container_vcores", "1", "--debug"};
        LOG.info((Object)"Initializing DS Client");
        Client client = new Client(new Configuration(this.yarnCluster.getConfig()));
        Assert.assertTrue((boolean)client.init(args));
        LOG.info((Object)"Running DS Client");
        Assert.assertTrue((boolean)client.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyContainerLog(int containerNum, List<String> expectedContent, boolean count, String expectedWord) {
        File logFolder = new File(this.yarnCluster.getNodeManager(0).getConfig().get("yarn.nodemanager.log-dirs", "/tmp/logs"));
        File[] listOfFiles = logFolder.listFiles();
        int currentContainerLogFileIndex = -1;
        for (int i = listOfFiles.length - 1; i >= 0; --i) {
            if (listOfFiles[i].listFiles().length != containerNum + 1) continue;
            currentContainerLogFileIndex = i;
            break;
        }
        Assert.assertTrue((currentContainerLogFileIndex != -1 ? 1 : 0) != 0);
        File[] containerFiles = listOfFiles[currentContainerLogFileIndex].listFiles();
        int numOfWords = 0;
        for (int i = 0; i < containerFiles.length; ++i) {
            for (File output : containerFiles[i].listFiles()) {
                if (!output.getName().trim().contains("stdout")) continue;
                BufferedReader br = null;
                ArrayList<String> stdOutContent = new ArrayList<String>();
                try {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(output));
                    int numOfline = 0;
                    while ((sCurrentLine = br.readLine()) != null) {
                        if (count) {
                            if (!sCurrentLine.contains(expectedWord)) continue;
                            ++numOfWords;
                            continue;
                        }
                        if (!output.getName().trim().equals("stdout")) continue;
                        if (!Shell.WINDOWS) {
                            Assert.assertEquals((String)("The current is" + sCurrentLine), (Object)expectedContent.get(numOfline), (Object)sCurrentLine.trim());
                            ++numOfline;
                            continue;
                        }
                        stdOutContent.add(sCurrentLine.trim());
                    }
                    if (!Shell.WINDOWS || count || !output.getName().trim().equals("stdout")) continue;
                    Assert.assertTrue((boolean)stdOutContent.containsAll(expectedContent));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return numOfWords;
    }
}

