/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class NNBench
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.NNBench");
    protected static String CONTROL_DIR_NAME = "control";
    protected static String OUTPUT_DIR_NAME = "output";
    protected static String DATA_DIR_NAME = "data";
    protected static final String DEFAULT_RES_FILE_NAME = "NNBench_results.log";
    protected static final String NNBENCH_VERSION = "Namenode Benchmark 0.5";
    protected static final String VOL_PREFIX = "nnvol";
    public static String operation = "none";
    public static long numberOfMaps = 1L;
    public static long numberOfReduces = 1L;
    public static long startTime = 120000L;
    public static long blockSize = 65536L;
    public static int bytesToWrite = 0;
    public static long bytesPerChecksum = 1L;
    public static long numberOfFiles = 1L;
    public static short replicationFactorPerFile = 1;
    public static String baseDir = "/benchmarks/NNBench";
    public static boolean readFileAfterOpen = false;
    public static int rateInterval = 10;
    public static String volPrefix = "nnvol";
    public static boolean deleteRenamed = false;
    public static boolean keepfiles = false;
    private static final String OP_CREATE_WRITE = "create_write";
    private static final String OP_OPEN_READ = "open_read";
    private static final String OP_RENAME = "rename";
    private static final String OP_DELETE = "delete";
    private static final String OP_CLEANUP = "cleanup";
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss','S");

    private static void cleanupBeforeTestrun(Configuration config) throws IOException {
        FileSystem tempFS = FileSystem.get((Configuration)config);
        if (operation.equals(OP_CLEANUP)) {
            LOG.info((Object)"Deleting data directory");
            if (tempFS.getUri().getScheme().equals("maprfs")) {
                LOG.info((Object)"Removing test volumes");
                if (!NNBench.removeMapRVolumesByFilter(baseDir)) {
                    throw new IOException("Could not cleanup the volumes");
                }
            } else {
                tempFS.delete(new Path(baseDir, DATA_DIR_NAME), true);
            }
        }
        tempFS.delete(new Path(baseDir, CONTROL_DIR_NAME), true);
        tempFS.delete(new Path(baseDir, OUTPUT_DIR_NAME), true);
    }

    private static boolean removeMapRVolumesByFilter(String baseDir) {
        String cmd = "maprcli volume remove -filter [mountdir==" + new Path(baseDir).toString() + "/*]";
        LOG.info((Object)("Running Command " + cmd));
        Runtime run = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = run.exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            pr.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return pr.exitValue() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createControlFiles(Configuration config) throws IOException {
        FileSystem tempFS = FileSystem.get((Configuration)config);
        LOG.info((Object)("Creating " + numberOfMaps + " control files"));
        int i = 0;
        while ((long)i < numberOfMaps) {
            String strFileName = "NNBench_Controlfile_" + i;
            Path filePath = new Path(new Path(baseDir, CONTROL_DIR_NAME), strFileName);
            Path destDir = new Path(new Path(baseDir), DATA_DIR_NAME);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)tempFS, (Configuration)config, (Path)filePath, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(destDir.toString()), (Writable)new LongWritable((long)i));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            ++i;
        }
    }

    private static void displayVersion() {
        System.out.println(NNBENCH_VERSION);
    }

    private static void displayUsage() {
        String usage = "Usage: nnbench <options>\nOptions:\n\t-operation <Available operations are create_write open_read rename delete cleanup. This option is mandatory>\n\t * NOTE: The open_read, rename and delete operations assume that the files they operate on, are already available. The create_write operation must be run before running the other operations.\n\t-delete_renamed. <Valid only for delete operation. Default is false. Used when running delete after rename.This is not mandatory.>\n\t-keepfiles. <Valid only for create_write operation.Default is true. This option will overwrite the previous files created under baseDir.This is not mandatory.Refer to readme for more details on this option.>\n\t-maps <number of maps. default is 1. This is not mandatory. If set by user, this must be less than or equal to the number of map slots on jobtracker>\n\t-rateInterval <interval at which mapper emits the rate of file operations. Default is 10s. This is not mandatory>\n\t-startTime <time to start, given in seconds from the epoch. Make sure this is far enough into the future, so all maps (operations) will start at the same time>. default is launch time + 2 mins. This is not mandatory \n\t-blockSize <Block size in bytes. default is 64K. Block size should be greater than or equal to 64K. This is not mandatory>\n\t-bytesToWrite <Bytes to write. default is 0. This is not mandatory>\n\t-bytesPerChecksum <Bytes per checksum for the files. default is 1. This is not mandatory>\n\t-numberOfFiles <total number of files to create. default is 1. This is not mandatory>\n\t-replicationFactorPerFile <Replication factor for the files.Default is 1. This is not mandatory>\n\t-baseDir <base DFS path. default is /benchmarks/NNBench. This is not mandatory>\n\t-volPrefix <prefix for volume names. default is nnvol.This is not mandatory>\n\t-readFileAfterOpen <true or false. if true, it reads the file and reports the average time to read. This is valid with the open_read operation. default is false. This is not mandatory>\n\t-help: Display the help statement\n";
        System.out.println(usage);
    }

    public static void displayReadme() {
        String readme = "\nREADME\n\nNNBench is a benchmark to measure the performance of the namenode metadata operations.\nFour metadata operation types are supported - \n 1.create and write to a file,\n 2.open and read from a file, \n 3.rename a file and \n 4.delete a file. \n\nAn additional cleanup operation is provided to remove all the volume and directories from under basedir. \n-baseDir is a mandatory option and must be provided with every operation.\n\nCommand line provides -maps option to specify number of map tasks for the job. \nIf the filesystem in use is the MapRFilesystem,a volume will be created per map task. \nBy default the volume name will be nnvol_<hostname>_<maptask id>. \nTo change the volume name and mount dir, use the -volPrefix option.\n\nFor operation create_write, files will be written to data dir - <basedir>/<volume mount path>/data dir.\nIf this dir already exists, job setup will fail asking you run cleanup operation or use -keepfiles option.\nTo grow the number of files under the same basedir and volumes, -keepfiles option can be used.\nIf data dir as stated above already exists, this option will be rename it to <data dir>.<yyyyMMddHHmmss> timestamped.\nTo grow the number of files under basedir but under different volumes,-volPrefix option can be used.\nFile names will be in the format file<mapid>_<fileindex>.\n\nopen_read operation always reads from files under <data dir>.\nAll the files for this benchmark should be under the above directory.\n\nrename operation will rename the files under <data dir> from file<mapid>_<fileindex> to file<mapid>_r_<fileindex>. \n\ndelete operation will delete all the files from under <basedir>/<volume mount path>/data but not the parent directories.\nIf delete is ran after a rename operation, make sure to specify-deleteRenamed option to delete files.\n\nThis version of NNBench also provides the ability to view the rate of each operation sampled every 10s.\nThe sampling interval can be changed using the -rateInterval option.\nThe rate information will be logged to stdout log of each map task.\n\n\nRefer to NNBench usage for more details on the options available and how to use each of them.\n\nGOODLUCK!!\n\n";
        System.out.println(readme);
    }

    public static void checkArgs(int index, int length) {
        if (index == length) {
            NNBench.displayUsage();
            System.exit(-1);
        }
    }

    public static void parseInputs(String[] args, Configuration config) {
        if (args.length == 0) {
            NNBench.displayReadme();
            NNBench.displayUsage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-operation")) {
                operation = args[++i];
                continue;
            }
            if (args[i].equals("-maps")) {
                NNBench.checkArgs(i + 1, args.length);
                numberOfMaps = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-rateInterval")) {
                NNBench.checkArgs(i + 1, args.length);
                rateInterval = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-startTime")) {
                NNBench.checkArgs(i + 1, args.length);
                startTime = Long.parseLong(args[++i]) * 1000L;
                continue;
            }
            if (args[i].equals("-blockSize")) {
                NNBench.checkArgs(i + 1, args.length);
                blockSize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesToWrite")) {
                NNBench.checkArgs(i + 1, args.length);
                bytesToWrite = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesPerChecksum")) {
                NNBench.checkArgs(i + 1, args.length);
                bytesPerChecksum = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-numberOfFiles")) {
                NNBench.checkArgs(i + 1, args.length);
                numberOfFiles = Long.parseLong(args[++i]) / numberOfMaps;
                continue;
            }
            if (args[i].equals("-replicationFactorPerFile")) {
                NNBench.checkArgs(i + 1, args.length);
                replicationFactorPerFile = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-baseDir")) {
                NNBench.checkArgs(i + 1, args.length);
                baseDir = args[++i];
                continue;
            }
            if (args[i].equals("-readFileAfterOpen")) {
                NNBench.checkArgs(i + 1, args.length);
                readFileAfterOpen = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-volPrefix")) {
                NNBench.checkArgs(i + 1, args.length);
                volPrefix = args[++i];
                continue;
            }
            if (args[i].equals("-delete_renamed")) {
                deleteRenamed = true;
                continue;
            }
            if (args[i].equals("-keepfiles")) {
                keepfiles = true;
                continue;
            }
            if (!args[i].equals("-help")) continue;
            NNBench.displayReadme();
            NNBench.displayUsage();
            System.exit(-1);
        }
    }

    private static void analyzeResults(Configuration config) throws IOException {
        double AverageExecutionTime;
        String line;
        FileSystem fs = FileSystem.get((Configuration)config);
        Path reduceFile = new Path(new Path(baseDir, OUTPUT_DIR_NAME), "part-00000");
        DataInputStream in = new DataInputStream((InputStream)fs.open(reduceFile));
        BufferedReader lines = new BufferedReader(new InputStreamReader(in));
        long totalTimeAL1 = 0L;
        long totalTimeAL2 = 0L;
        long totalTimeTPmS = 0L;
        long lateMaps = 0L;
        long numOfExceptions = 0L;
        long successfulFileOps = 0L;
        long mapStartTimeTPmS = 0L;
        long mapEndTimeTPmS = 0L;
        String resultTPSLine1 = null;
        String resultTPSLine2 = null;
        String resultALLine1 = null;
        String resultALLine2 = null;
        while ((line = lines.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%;");
            String attr = tokens.nextToken();
            if (attr.endsWith(":totalTimeAL1")) {
                totalTimeAL1 = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":totalTimeAL2")) {
                totalTimeAL2 = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":totalTimeTPmS")) {
                totalTimeTPmS = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":latemaps")) {
                lateMaps = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":numOfExceptions")) {
                numOfExceptions = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":successfulFileOps")) {
                successfulFileOps = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":mapStartTimeTPmS")) {
                mapStartTimeTPmS = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (!attr.endsWith(":mapEndTimeTPmS")) continue;
            mapEndTimeTPmS = Long.parseLong(tokens.nextToken());
        }
        double avgLatency1 = (double)totalTimeAL1 / (double)successfulFileOps;
        double avgLatency2 = (double)totalTimeAL2 / (double)successfulFileOps;
        double longestMapTimeTPmS = mapEndTimeTPmS - mapStartTimeTPmS;
        double totalTimeTPS = longestMapTimeTPmS == 0.0 ? (double)(1000L * successfulFileOps) : (double)(1000L * successfulFileOps) / longestMapTimeTPmS;
        double d = AverageExecutionTime = totalTimeTPmS == 0L ? (double)successfulFileOps : (double)totalTimeTPmS / (double)successfulFileOps;
        if (operation.equals(OP_CREATE_WRITE)) {
            resultTPSLine1 = "               TPS: Create/Write/Close: " + (int)(totalTimeTPS * 2.0);
            resultTPSLine2 = "Avg exec time (ms): Create/Write/Close: " + AverageExecutionTime;
            resultALLine1 = "            Avg Lat (ms): Create/Write: " + avgLatency1;
            resultALLine2 = "                   Avg Lat (ms): Close: " + avgLatency2;
        } else if (operation.equals(OP_OPEN_READ)) {
            resultTPSLine1 = "                        TPS: Open/Read: " + (int)totalTimeTPS;
            resultTPSLine2 = "         Avg Exec time (ms): Open/Read: " + AverageExecutionTime;
            resultALLine1 = "                    Avg Lat (ms): Open: " + avgLatency1;
            if (readFileAfterOpen) {
                resultALLine2 = "                  Avg Lat (ms): Read: " + avgLatency2;
            }
        } else if (operation.equals(OP_RENAME)) {
            resultTPSLine1 = "                           TPS: Rename: " + (int)totalTimeTPS;
            resultTPSLine2 = "            Avg Exec time (ms): Rename: " + AverageExecutionTime;
            resultALLine1 = "                  Avg Lat (ms): Rename: " + avgLatency1;
        } else if (operation.equals(OP_DELETE)) {
            resultTPSLine1 = "                           TPS: Delete: " + (int)totalTimeTPS;
            resultTPSLine2 = "            Avg Exec time (ms): Delete: " + AverageExecutionTime;
            resultALLine1 = "                  Avg Lat (ms): Delete: " + avgLatency1;
        }
        String[] resultLines = new String[]{"-------------- NNBench -------------- : ", "                               Version: Namenode Benchmark 0.5", "                           Date & time: " + sdf.format(new Date(System.currentTimeMillis())), "", "                        Test Operation: " + operation, "                            Start time: " + sdf.format(new Date(startTime)), "                           Maps to run: " + numberOfMaps, "                        Reduces to run: " + numberOfReduces, "                    Block Size (bytes): " + blockSize, "                        Bytes to write: " + bytesToWrite, "                    Bytes per checksum: " + bytesPerChecksum, "                       Number of files: " + numberOfFiles, "                    Replication factor: " + replicationFactorPerFile, "            Successful file operations: " + successfulFileOps, "", "        # maps that missed the barrier: " + lateMaps, "                          # exceptions: " + numOfExceptions, "", resultTPSLine1, resultTPSLine2, resultALLine1, resultALLine2, "", "                 RAW DATA: AL Total #1: " + totalTimeAL1, "                 RAW DATA: AL Total #2: " + totalTimeAL2, "              RAW DATA: TPS Total (ms): " + totalTimeTPmS, "       RAW DATA: Longest Map Time (ms): " + longestMapTimeTPmS, "                   RAW DATA: Late maps: " + lateMaps, "             RAW DATA: # of exceptions: " + numOfExceptions, ""};
        PrintStream res = new PrintStream(new FileOutputStream(new File(DEFAULT_RES_FILE_NAME), true));
        for (int i = 0; i < resultLines.length; ++i) {
            LOG.info((Object)resultLines[i]);
            res.println(resultLines[i]);
        }
    }

    public static void runTests(Configuration config) throws IOException {
        config.setLong("io.bytes.per.checksum", bytesPerChecksum);
        JobConf job = new JobConf(config, NNBench.class);
        job.setJobName("NNBench-" + operation);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(baseDir, CONTROL_DIR_NAME)});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMaxMapAttempts(1);
        job.setSpeculativeExecution(false);
        job.setMapperClass(NNBenchMapper.class);
        job.setReducerClass(NNBenchReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(baseDir, OUTPUT_DIR_NAME));
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks((int)numberOfReduces);
        job.setBoolean("mapred.map.tasks.speculative.execution", false);
        job.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        JobClient.runJob((JobConf)job);
    }

    public static void validateInputs(Configuration config) {
        if (!(operation.equals(OP_CREATE_WRITE) || operation.equals(OP_OPEN_READ) || operation.equals(OP_RENAME) || operation.equals(OP_DELETE))) {
            System.err.println("Error: Unknown operation: " + operation);
            NNBench.displayUsage();
            System.exit(-1);
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)config);
            if (!keepfiles && operation.equals(OP_CREATE_WRITE) && fs.exists(new Path(baseDir)) && fs.listStatus(new Path(baseDir)).length > 0) {
                System.err.println("Error: Files exist under baseDir. Use -operation cleanup to cleanup the files or -keepfiles to keep the files by renaming the data directory");
                NNBench.displayUsage();
                System.exit(-1);
            }
            if (keepfiles && operation.equals(OP_CREATE_WRITE) && (!fs.exists(new Path(baseDir)) || fs.listStatus(new Path(baseDir)).length <= 0)) {
                keepfiles = false;
            }
            if ((operation.equals(OP_DELETE) || operation.equals(OP_OPEN_READ) || operation.equals(OP_RENAME)) && !fs.exists(new Path(baseDir))) {
                System.err.println("baseDir does not exist.Make sure baseDir exists and has files in it to perform operation " + operation);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (numberOfMaps <= 0L) {
            System.err.println("Error: Number of maps must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (blockSize <= 65535L) {
            System.err.println("Error: Block size must be greater than 64K");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (bytesToWrite < 0) {
            System.err.println("Error: Bytes to write must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (bytesPerChecksum < 0L) {
            System.err.println("Error: Bytes per checksum must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (numberOfFiles < 0L) {
            System.err.println("Error: Number of files must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (replicationFactorPerFile < 0) {
            System.err.println("Error: Replication factor must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (blockSize % bytesPerChecksum != 0L) {
            System.err.println("Error: Block Size in bytes must be a multiple of bytes per checksum: ");
            NNBench.displayUsage();
            System.exit(-1);
        }
        config.set("test.nnbench.operation", operation);
        config.setLong("test.nnbench.maps", numberOfMaps);
        config.setLong("test.nnbench.starttime", System.currentTimeMillis() + startTime);
        config.setLong("test.nnbench.blocksize", blockSize);
        config.setInt("test.nnbench.bytestowrite", bytesToWrite);
        config.setLong("test.nnbench.bytesperchecksum", bytesPerChecksum);
        config.setLong("test.nnbench.numberoffiles", numberOfFiles);
        config.setInt("test.nnbench.replicationfactor", (int)replicationFactorPerFile);
        config.set("test.nnbench.basedir", baseDir);
        config.setBoolean("test.nnbench.readFileAfterOpen", readFileAfterOpen);
        config.setInt("test.nnbench.rateInterval", rateInterval);
        config.set("test.nnbench.datadir.name", DATA_DIR_NAME);
        config.set("test.nnbench.outputdir.name", OUTPUT_DIR_NAME);
        config.set("test.nnbench.controldir.name", CONTROL_DIR_NAME);
        config.set("test.nnbench.volprefix.name", volPrefix);
        config.setBoolean("test.nnbench.delete.renamed", deleteRenamed);
        config.setBoolean("test.nnbench.keepfiles", keepfiles);
        String maprInstallDir = System.getProperty("mapr.home.dir");
        if (maprInstallDir == null && (maprInstallDir = System.getenv("MAPR_HOME")) == null) {
            maprInstallDir = "/opt/mapr/";
        }
        config.set("tasktracker.hostname.file", new Path(new Path(maprInstallDir), "hostname").toString());
        LOG.info((Object)"Test Inputs: ");
        LOG.info((Object)("           Test Operation: " + operation));
        LOG.info((Object)("               Start time: " + sdf.format(new Date(startTime))));
        LOG.info((Object)("           Number of maps: " + numberOfMaps));
        LOG.info((Object)("        Number of reduces: " + numberOfReduces));
        LOG.info((Object)("               Block Size: " + blockSize));
        LOG.info((Object)("           Bytes to write: " + bytesToWrite));
        LOG.info((Object)("       Bytes per checksum: " + bytesPerChecksum));
        LOG.info((Object)("  Number of files per map: " + numberOfFiles));
        LOG.info((Object)("       Replication factor: " + replicationFactorPerFile));
        LOG.info((Object)("                 Base dir: " + baseDir));
        LOG.info((Object)("     Read file after open: " + readFileAfterOpen));
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new NNBench(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Configuration config = this.getConf();
        NNBench.displayVersion();
        NNBench.parseInputs(args, config);
        NNBench.cleanupBeforeTestrun(config);
        if (operation.equals(OP_CLEANUP)) {
            return 0;
        }
        NNBench.validateInputs(config);
        NNBench.createControlFiles(config);
        NNBench.runTests(config);
        NNBench.analyzeResults(config);
        return 0;
    }

    static class NNBenchReducer
    extends MapReduceBase
    implements Reducer<Text, Text, Text, Text> {
        protected String hostName;

        public NNBenchReducer() {
            LOG.info((Object)"Starting NNBenchReducer !!!");
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.hostName = "localhost";
            }
            LOG.info((Object)("Starting NNBenchReducer on " + this.hostName));
        }

        public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            long value;
            String field = key.toString();
            reporter.setStatus("starting " + field + " ::host = " + this.hostName);
            if (field.startsWith("l:")) {
                long lSum = 0L;
                while (values.hasNext()) {
                    lSum += Long.parseLong(values.next().toString());
                }
                output.collect((Object)key, (Object)new Text(String.valueOf(lSum)));
            }
            if (field.startsWith("min:")) {
                long minVal = -1L;
                while (values.hasNext()) {
                    value = Long.parseLong(values.next().toString());
                    if (minVal == -1L) {
                        minVal = value;
                        continue;
                    }
                    if (value == 0L || value >= minVal) continue;
                    minVal = value;
                }
                output.collect((Object)key, (Object)new Text(String.valueOf(minVal)));
            }
            if (field.startsWith("max:")) {
                long maxVal = -1L;
                while (values.hasNext()) {
                    value = Long.parseLong(values.next().toString());
                    if (maxVal == -1L) {
                        maxVal = value;
                        continue;
                    }
                    if (value <= maxVal) continue;
                    maxVal = value;
                }
                output.collect((Object)key, (Object)new Text(String.valueOf(maxVal)));
            }
            reporter.setStatus("finished " + field + " ::host = " + this.hostName);
        }
    }

    static class NNBenchMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, Text> {
        FileSystem filesystem = null;
        private static String hostName = null;
        long numberOfFiles = 1L;
        long blkSize = 65536L;
        short replFactor = 1;
        int bytesToWrite = 0;
        String baseDir = null;
        String dataDirName = null;
        static Path dataDir = null;
        String op = null;
        boolean readFile = false;
        final int MAX_OPERATION_EXCEPTIONS = 1000;
        static int rateInterval = 10;
        private static long mapFileIndex = 0L;
        int numOfExceptions = 0;
        long startTimeAL = 0L;
        long totalTimeAL1 = 0L;
        long totalTimeAL2 = 0L;
        static long successfulFileOps = 0L;
        String hostNameFile;
        boolean deleteRenamed;
        boolean keepfiles;

        public void configure(JobConf conf) {
            this.setConf((Configuration)conf);
            try {
                this.filesystem = FileSystem.get((Configuration)conf);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get file system.", e);
            }
            try {
                this.hostNameFile = conf.get("tasktracker.hostname.file", "/opt/mapr/hostname");
                File hostFile = new File(this.hostNameFile);
                if (hostFile.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(hostFile));
                    hostName = reader.readLine();
                    reader.close();
                } else {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                String attemptid = conf.get("mapred.tip.id");
                String[] atemp = attemptid.split("_");
                mapFileIndex = Long.parseLong(atemp[atemp.length - 1]);
                this.numberOfFiles = conf.getLong("test.nnbench.numberoffiles", 1L);
                this.blkSize = conf.getLong("test.nnbench.blocksize", 1L);
                this.replFactor = (short)conf.getInt("test.nnbench.replicationfactor", 1);
                this.bytesToWrite = conf.getInt("test.nnbench.bytestowrite", 0);
                this.baseDir = conf.get("test.nnbench.basedir");
                this.dataDirName = conf.get("test.nnbench.datadir.name") + "_" + hostName + "_" + mapFileIndex;
                dataDir = new Path(new Path(new Path(this.baseDir), this.dataDirName), conf.get("test.nnbench.datadir.name"));
                this.op = conf.get("test.nnbench.operation");
                this.readFile = conf.getBoolean("test.nnbench.readFileAfterOpen", false);
                rateInterval = conf.getInt("test.nnbench.rateInterval", 10);
                this.keepfiles = conf.getBoolean("test.nnbench.keepfiles", false);
                if (this.op.equals(NNBench.OP_DELETE)) {
                    this.deleteRenamed = conf.getBoolean("test.nnbench.delete.renamed", false);
                }
                if (this.filesystem.getUri().getScheme().equals("maprfs") && this.op.equals(NNBench.OP_CREATE_WRITE) && !this.keepfiles) {
                    String volumeName = conf.get("test.nnbench.volprefix.name", NNBench.VOL_PREFIX) + "_" + hostName + "_" + mapFileIndex;
                    try {
                        if (!this.createMapRVolume(volumeName, dataDir, this.replFactor)) {
                            throw new IOException("Error creating volume for mapper");
                        }
                    }
                    catch (IOException ie) {
                        throw new IOException("Error creating volume for mapper: " + ie.getMessage());
                    }
                    catch (Exception e) {
                        throw new IOException("Error creating volume for mapper: " + e.getMessage());
                    }
                }
                if (this.keepfiles && this.op.equals(NNBench.OP_CREATE_WRITE) && this.filesystem.exists(dataDir)) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                    String time_rep = "";
                    time_rep = formatter.format(new Date(System.currentTimeMillis()));
                    this.filesystem.rename(dataDir, new Path(dataDir.toString() + "." + time_rep));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in setup", e);
            }
        }

        public void close() throws IOException {
        }

        private boolean barrier() {
            long startTime = this.getConf().getLong("test.nnbench.starttime", 0L);
            long currentTime = System.currentTimeMillis();
            long sleepTime = startTime - currentTime;
            boolean retVal = false;
            if (sleepTime > 0L) {
                LOG.info((Object)("Waiting in barrier for: " + sleepTime + " ms"));
                try {
                    Thread.sleep(sleepTime);
                    retVal = true;
                }
                catch (Exception e) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public void map(Text key, LongWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            Configuration conf = this.filesystem.getConf();
            long totalTimeTPmS = 0L;
            long startTimeTPmS = 0L;
            long endTimeTPms = 0L;
            this.numOfExceptions = 0;
            this.startTimeAL = 0L;
            this.totalTimeAL1 = 0L;
            this.totalTimeAL2 = 0L;
            successfulFileOps = 0L;
            RateLoggerThread logThread = new RateLoggerThread();
            if (this.barrier()) {
                LOG.info((Object)"Out of barrier. Starting benchmark now!");
                logThread.start();
                if (this.op.equals(NNBench.OP_CREATE_WRITE)) {
                    startTimeTPmS = System.currentTimeMillis();
                    this.doCreateWriteOp("file" + mapFileIndex, reporter);
                } else if (this.op.equals(NNBench.OP_OPEN_READ)) {
                    startTimeTPmS = System.currentTimeMillis();
                    this.doOpenReadOp("file" + mapFileIndex, reporter);
                } else if (this.op.equals(NNBench.OP_RENAME)) {
                    startTimeTPmS = System.currentTimeMillis();
                    this.doRenameOp("file" + mapFileIndex, reporter);
                } else if (this.op.equals(NNBench.OP_DELETE)) {
                    startTimeTPmS = System.currentTimeMillis();
                    this.doDeleteOp("file" + mapFileIndex, reporter);
                }
                long lastTimeElapsed = (System.currentTimeMillis() - (startTimeTPmS + (long)(RateLoggerThread.i * rateInterval))) / 1000L;
                System.out.println("[NNBENCH] Hostname:" + hostName + " " + "Taskid:" + mapFileIndex + " " + "Timestamp:" + System.currentTimeMillis() + " Time:" + lastTimeElapsed + "s" + " operation:" + operation + " operations:" + successfulFileOps + " OpsLast" + rateInterval + "s:" + (successfulFileOps - RateLoggerThread.lastFilesCreated) + " AvgRateLast" + rateInterval + "s:" + (successfulFileOps - RateLoggerThread.lastFilesCreated) / (long)rateInterval + " WorkingDir " + dataDir.toString());
                endTimeTPms = System.currentTimeMillis();
                totalTimeTPmS = endTimeTPms - startTimeTPmS;
            } else {
                output.collect((Object)new Text("l:latemaps"), (Object)new Text("1"));
            }
            output.collect((Object)new Text("l:totalTimeAL1"), (Object)new Text(String.valueOf(this.totalTimeAL1)));
            output.collect((Object)new Text("l:totalTimeAL2"), (Object)new Text(String.valueOf(this.totalTimeAL2)));
            output.collect((Object)new Text("l:numOfExceptions"), (Object)new Text(String.valueOf(this.numOfExceptions)));
            output.collect((Object)new Text("l:successfulFileOps"), (Object)new Text(String.valueOf(successfulFileOps)));
            output.collect((Object)new Text("l:totalTimeTPmS"), (Object)new Text(String.valueOf(totalTimeTPmS)));
            output.collect((Object)new Text("min:mapStartTimeTPmS"), (Object)new Text(String.valueOf(startTimeTPmS)));
            output.collect((Object)new Text("max:mapEndTimeTPmS"), (Object)new Text(String.valueOf(endTimeTPms)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean maprVolumeExists(String volumeName) throws Exception {
            BufferedInputStream in;
            if (volumeName == null || volumeName.equals("")) {
                return false;
            }
            String cmd = "maprcli volume list -filter [n==" + volumeName + "] -columns volumename";
            Runtime run = Runtime.getRuntime();
            StringBuilder sb = new StringBuilder();
            String outStr = null;
            String errorStr = null;
            Process pr = null;
            try {
                pr = run.exec(cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                pr.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (pr.exitValue() == 0) {
                try {
                    in = new BufferedInputStream(pr.getInputStream());
                    byte[] bt = new byte[100];
                    int off = 0;
                    int bRead = 0;
                    while ((bRead = in.read(bt)) != -1) {
                        sb.append(new String(bt));
                        off += bRead;
                    }
                    in.close();
                    if (sb.length() <= 0) return false;
                    outStr = sb.toString();
                    String[] names = sb.toString().split("\\n");
                    for (int i = 1; i < names.length; ++i) {
                        if (!names[i].trim().equals(volumeName)) continue;
                        return true;
                    }
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            } else {
                try {
                    in = new BufferedInputStream(pr.getErrorStream());
                    sb = new StringBuilder();
                    byte[] bt = new byte[100];
                    int off = 0;
                    int bRead = 0;
                    while ((bRead = in.read(bt)) != -1) {
                        sb.append(new String(bt));
                        off += bRead;
                    }
                    in.close();
                    if (sb.length() <= 0) return false;
                    errorStr = sb.toString();
                    throw new Exception("Error listing volumes: " + errorStr);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }

        private boolean createMapRVolume(String volumeName, Path path, short replication) throws IOException, Exception {
            if (volumeName == null || volumeName.equals("") || path == null || path.toString().equals("")) {
                return false;
            }
            boolean volumeExists = false;
            try {
                volumeExists = NNBenchMapper.maprVolumeExists(volumeName);
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            if (!volumeExists) {
                String command = "maprcli volume create -name " + volumeName + " -path " + path.getParent() + " -replication " + replication;
                Runtime run = Runtime.getRuntime();
                Process pr = null;
                StringBuilder sb = new StringBuilder();
                Object outStr = null;
                String errorStr = null;
                try {
                    pr = run.exec(command);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    pr.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (pr.exitValue() == 0) {
                    return true;
                }
                try {
                    byte[] bt = new byte[100];
                    int off = 0;
                    int bRead = 0;
                    BufferedInputStream in = new BufferedInputStream(pr.getErrorStream());
                    while ((bRead = in.read(bt)) != -1) {
                        sb.append(new String(bt));
                        off += bRead;
                    }
                    in.close();
                    if (sb.length() > 0) {
                        errorStr = sb.toString();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (errorStr != null) {
                    throw new Exception("Error creating volume:" + errorStr);
                }
            } else {
                throw new IOException("Error creating volume:Volume " + volumeName + " already exists. Use -volPrefix to create new volumes or cleanup " + "operation to remove the existing volumes");
            }
            return false;
        }

        private void doCreateWriteOp(String name, Reporter reporter) {
            byte[] buffer = new byte[this.bytesToWrite];
            for (long l = 0L; l < this.numberOfFiles; ++l) {
                Path filePath = new Path(dataDir, name + "_" + l);
                boolean successfulOp = false;
                while (!successfulOp && this.numOfExceptions < 1000) {
                    try {
                        this.startTimeAL = System.currentTimeMillis();
                        FSDataOutputStream out = this.filesystem.create(filePath, true, 512, this.replFactor, this.blkSize);
                        out.write(buffer);
                        this.totalTimeAL1 += System.currentTimeMillis() - this.startTimeAL;
                        this.startTimeAL = System.currentTimeMillis();
                        out.close();
                        this.totalTimeAL2 += System.currentTimeMillis() - this.startTimeAL;
                        successfulOp = true;
                        ++successfulFileOps;
                        reporter.setStatus("Finish " + l + " files");
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception recorded in op: Create/Write/Close");
                        ++this.numOfExceptions;
                    }
                }
            }
        }

        private void doOpenReadOp(String name, Reporter reporter) {
            byte[] buffer = new byte[this.bytesToWrite];
            for (long l = 0L; l < this.numberOfFiles; ++l) {
                Path filePath = new Path(dataDir, name + "_" + l);
                boolean successfulOp = false;
                while (!successfulOp && this.numOfExceptions < 1000) {
                    try {
                        FSDataInputStream input;
                        block7: {
                            this.startTimeAL = System.currentTimeMillis();
                            input = this.filesystem.open(filePath);
                            this.totalTimeAL1 += System.currentTimeMillis() - this.startTimeAL;
                            if (this.readFile) {
                                this.startTimeAL = System.currentTimeMillis();
                                input.readFully(buffer);
                                this.totalTimeAL2 += System.currentTimeMillis() - this.startTimeAL;
                            }
                            try {
                                input.adviseFile(FSDataInputStream.FadviseType.FILE_DONTNEED, 0L, (long)buffer.length);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isInfoEnabled()) break block7;
                                LOG.info((Object)("Error " + ioe + " in fadvise. Ignoring it."));
                            }
                        }
                        input.close();
                        successfulOp = true;
                        ++successfulFileOps;
                        reporter.setStatus("Finish " + l + " files");
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Exception recorded in op: OpenRead " + e));
                        ++this.numOfExceptions;
                    }
                }
            }
        }

        private void doRenameOp(String name, Reporter reporter) {
            for (long l = 0L; l < this.numberOfFiles; ++l) {
                Path filePath = new Path(dataDir, name + "_" + l);
                Path filePathR = new Path(dataDir, name + "_r_" + l);
                boolean successfulOp = false;
                while (!successfulOp && this.numOfExceptions < 1000) {
                    try {
                        this.startTimeAL = System.currentTimeMillis();
                        this.filesystem.rename(filePath, filePathR);
                        this.totalTimeAL1 += System.currentTimeMillis() - this.startTimeAL;
                        successfulOp = true;
                        ++successfulFileOps;
                        reporter.setStatus("Finish " + l + " files");
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception recorded in op: Rename");
                        ++this.numOfExceptions;
                    }
                }
            }
        }

        private void doDeleteOp(String name, Reporter reporter) {
            for (long l = 0L; l < this.numberOfFiles; ++l) {
                Path filePath = null;
                filePath = !this.deleteRenamed ? new Path(dataDir, name + "_" + l) : new Path(dataDir, name + "_r_" + l);
                boolean successfulOp = false;
                while (!successfulOp && this.numOfExceptions < 1000) {
                    try {
                        this.startTimeAL = System.currentTimeMillis();
                        this.filesystem.delete(filePath, true);
                        this.totalTimeAL1 += System.currentTimeMillis() - this.startTimeAL;
                        successfulOp = true;
                        ++successfulFileOps;
                        reporter.setStatus("Finish " + l + " files");
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception in recorded op: Delete");
                        ++this.numOfExceptions;
                    }
                }
            }
        }

        public static class RateLoggerThread
        extends Thread {
            static long lastFilesCreated = 0L;
            static long currentFilesCreated = 0L;
            static int i = 0;

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(rateInterval * 1000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                    currentFilesCreated = successfulFileOps;
                    long lastTimeElapsed = ++i * rateInterval;
                    System.out.println("[NNBENCH] Hostname:" + hostName + " " + "Taskid:" + mapFileIndex + " " + "Timestamp:" + System.currentTimeMillis() + " " + "Time:" + lastTimeElapsed + "s" + " operation:" + operation + " operations:" + currentFilesCreated + " OpsLast" + rateInterval + "s:" + (currentFilesCreated - lastFilesCreated) + " AvgRateLast" + rateInterval + "s:" + (currentFilesCreated - lastFilesCreated) / (long)rateInterval + " WorkingDir " + dataDir.toString());
                    lastFilesCreated = currentFilesCreated;
                }
            }
        }
    }
}

