/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.MultiFileWordCount;
import org.apache.hadoop.examples.WordCount;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestMapReduceLocal
extends TestCase {
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
    private static Configuration conf = new Configuration();
    private static FileSystem localFs;

    public static Path writeFile(String name, String data) throws IOException {
        Path file = new Path(TEST_ROOT_DIR + "/" + name);
        localFs.delete(file, false);
        FSDataOutputStream f = localFs.create(file);
        f.write(data.getBytes());
        f.close();
        return file;
    }

    public static String readFile(String name) throws IOException {
        FSDataInputStream f = localFs.open(new Path(TEST_ROOT_DIR + "/" + name));
        BufferedReader b = new BufferedReader(new InputStreamReader((InputStream)f));
        StringBuilder result = new StringBuilder();
        String line = b.readLine();
        while (line != null) {
            result.append(line);
            result.append('\n');
            line = b.readLine();
        }
        b.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithLocal() throws Exception {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            JobConf conf = mr.createJobConf();
            this.runWordCount((Configuration)conf);
            this.runMultiFileWordCount((Configuration)conf);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private void runWordCount(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        String COUNTER_GROUP = "org.apache.hadoop.mapred.Task$Counter";
        localFs.delete(new Path(TEST_ROOT_DIR + "/in"), true);
        localFs.delete(new Path(TEST_ROOT_DIR + "/out"), true);
        TestMapReduceLocal.writeFile("in/part1", "this is a test\nof word count test\ntest\n");
        TestMapReduceLocal.writeFile("in/part2", "more test");
        Job job = new Job(conf, "word count");
        job.setJarByClass(WordCount.class);
        job.setMapperClass(WordCount.TokenizerMapper.class);
        job.setCombinerClass(WordCount.IntSumReducer.class);
        job.setReducerClass(WordCount.IntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setInputFormatClass(TrackingTextInputFormat.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/in"));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/out"));
        TestMapReduceLocal.assertNull((Object)job.getJobID());
        TestMapReduceLocal.assertTrue((boolean)job.waitForCompletion(false));
        TestMapReduceLocal.assertNotNull((Object)job.getJobID());
        String out = TestMapReduceLocal.readFile("out/part-r-00000");
        System.out.println(out);
        TestMapReduceLocal.assertEquals((String)"a\t1\ncount\t1\nis\t1\nmore\t1\nof\t1\ntest\t4\nthis\t1\nword\t1\n", (String)out);
        Counters ctrs = job.getCounters();
        System.out.println("Counters: " + ctrs);
        long combineIn = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "COMBINE_INPUT_RECORDS").getValue();
        long combineOut = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "COMBINE_OUTPUT_RECORDS").getValue();
        long reduceIn = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "REDUCE_INPUT_RECORDS").getValue();
        long mapOut = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_OUTPUT_RECORDS").getValue();
        long reduceOut = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "REDUCE_OUTPUT_RECORDS").getValue();
        long reduceGrps = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "REDUCE_INPUT_GROUPS").getValue();
        TestMapReduceLocal.assertEquals((String)"map out = combine in", (long)mapOut, (long)combineIn);
        TestMapReduceLocal.assertEquals((String)"combine out = reduce in", (long)combineOut, (long)reduceIn);
        TestMapReduceLocal.assertTrue((String)"combine in > combine out", (combineIn > combineOut ? 1 : 0) != 0);
        TestMapReduceLocal.assertEquals((String)"reduce groups = reduce out", (long)reduceGrps, (long)reduceOut);
        String group = "Random Group";
        CounterGroup ctrGrp = (CounterGroup)ctrs.getGroup(group);
        TestMapReduceLocal.assertEquals((int)0, (int)ctrGrp.size());
    }

    public void runMultiFileWordCount(Configuration conf) throws Exception {
        localFs.delete(new Path(TEST_ROOT_DIR + "/in"), true);
        localFs.delete(new Path(TEST_ROOT_DIR + "/out"), true);
        TestMapReduceLocal.writeFile("in/part1", "this is a test\nof multi file word count test\ntest\n");
        TestMapReduceLocal.writeFile("in/part2", "more test");
        int ret = ToolRunner.run((Configuration)conf, (Tool)new MultiFileWordCount(), (String[])new String[]{TEST_ROOT_DIR + "/in", TEST_ROOT_DIR + "/out"});
        TestMapReduceLocal.assertTrue((String)"MultiFileWordCount failed", (ret == 0 ? 1 : 0) != 0);
        String out = TestMapReduceLocal.readFile("out/part-r-00000");
        System.out.println(out);
        TestMapReduceLocal.assertEquals((String)"a\t1\ncount\t1\nfile\t1\nis\t1\nmore\t1\nmulti\t1\nof\t1\ntest\t4\nthis\t1\nword\t1\n", (String)out);
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
    }

    public static class TrackingTextInputFormat
    extends TextInputFormat {
        public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new MonoProgressRecordReader();
        }

        public static class MonoProgressRecordReader
        extends LineRecordReader {
            private float last = 0.0f;
            private boolean progressCalled = false;

            public float getProgress() throws IOException {
                this.progressCalled = true;
                float ret = super.getProgress();
                Assert.assertTrue((String)"getProgress decreased", (ret >= this.last ? 1 : 0) != 0);
                this.last = ret;
                return ret;
            }

            public synchronized void close() throws IOException {
                Assert.assertTrue((String)"getProgress never called", (boolean)this.progressCalled);
                super.close();
            }
        }
    }
}

