/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJvmManager {
    private static File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestJvmManager.class.getSimpleName());
    private static int MAP_SLOTS = 1;
    private static int REDUCE_SLOTS = 1;
    private TaskTracker tt;
    private JvmManager jvmManager;
    private JobConf ttConf;
    private boolean threadCaughtException = false;
    private String user = UserGroupInformation.getCurrentUser().getShortUserName();

    @Before
    public void setUp() {
        TEST_DIR.mkdirs();
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    public TestJvmManager() throws Exception {
        this.tt = new TaskTracker();
        this.ttConf = new JobConf();
        this.ttConf.setLong("mapred.tasktracker.tasks.sleeptime-before-sigkill", 2000L);
        this.tt.setConf(this.ttConf);
        this.tt.setMaxMapSlots(MAP_SLOTS);
        this.tt.setMaxReduceSlots(REDUCE_SLOTS);
        DefaultTaskController dtc = new DefaultTaskController();
        this.tt.setTaskController((TaskController)dtc);
        Configuration conf = new Configuration();
        dtc.setConf(conf);
        LocalDirAllocator ldirAlloc = new LocalDirAllocator("mapred.local.dir");
        this.tt.getTaskController().setup(ldirAlloc);
        JobID jobId = new JobID("test", 0);
        this.jvmManager = new JvmManager(this.tt);
        this.tt.setJvmManagerInstance(this.jvmManager);
        this.tt.setUserLogManager(new UserLogManager((Configuration)this.ttConf));
        this.tt.setCleanupThread((CleanupQueue)new UtilsForTests.InlineCleanupQueue());
    }

    private File writeScript(String fileName, String cmd, File pidFile) throws IOException {
        File script = new File(TEST_DIR, fileName);
        FileOutputStream out = new FileOutputStream(script);
        out.write(("echo $$ >" + pidFile.toString() + ";").getBytes());
        out.write("trap '' 15\n".getBytes());
        out.write(cmd.getBytes());
        out.close();
        script.setExecutable(true);
        return script;
    }

    @Test
    public void testJvmKill() throws Exception {
        JvmManager.JvmManagerForType mapJvmManager = this.jvmManager.getJvmManagerForType(TaskType.MAP);
        JobConf taskConf = new JobConf((Configuration)this.ttConf);
        TaskAttemptID attemptID = new TaskAttemptID("test", 0, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, MAP_SLOTS);
        task.setUser(this.user);
        task.setConf((Configuration)taskConf);
        TaskTracker taskTracker = this.tt;
        taskTracker.getClass();
        TaskTracker.TaskInProgress tip = new TaskTracker.TaskInProgress(taskTracker, (Task)task, taskConf);
        File pidFile = new File(TEST_DIR, "pid");
        TaskTracker.RunningJob rjob = new TaskTracker.RunningJob(attemptID.getJobID());
        DefaultTaskController taskController = new DefaultTaskController();
        taskController.setConf((Configuration)this.ttConf);
        rjob.distCacheMgr = new TrackerDistributedCacheManager((Configuration)this.ttConf, (TaskController)taskController).newTaskDistributedCacheManager((org.apache.hadoop.mapreduce.JobID)attemptID.getJobID(), (Configuration)taskConf);
        final TaskRunner taskRunner = task.createRunner(this.tt, tip, rjob);
        final Vector<String> vargs = new Vector<String>(2);
        vargs.add(this.writeScript("SLEEP", "sleep 60\n", pidFile).getAbsolutePath());
        final File workDir = new File(TEST_DIR, "work");
        final File stdout = new File(TEST_DIR, "stdout");
        final File stderr = new File(TEST_DIR, "stderr");
        Thread launcher = new Thread(){

            @Override
            public void run() {
                try {
                    taskRunner.launchJvmAndWait(null, null, vargs, stdout, stderr, 100L, workDir);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
            }
        };
        launcher.start();
        for (int i = 0; i < 10 && !pidFile.exists(); ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertTrue((String)"pidFile is not present", (boolean)pidFile.exists());
        BufferedReader in = new BufferedReader(new FileReader(pidFile));
        String pid = in.readLine();
        in.close();
        JVMId jvmid = (JVMId)mapJvmManager.runningTaskToJvm.get(taskRunner);
        this.jvmManager.setPidToJvm(jvmid, pid);
        final JvmManager.JvmManagerForType.JvmRunner jvmRunner = (JvmManager.JvmManagerForType.JvmRunner)mapJvmManager.jvmIdToRunner.get(jvmid);
        Thread killer = new Thread(){

            @Override
            public void run() {
                try {
                    jvmRunner.kill(null, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    TestJvmManager.this.setThreadCaughtException();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        killer.start();
        Thread.sleep(100L);
        taskRunner.kill(false);
        Assert.assertTrue((boolean)jvmRunner.killed);
        attemptID = new TaskAttemptID("test", 0, true, 0, 1);
        task = new MapTask(null, attemptID, 0, null, MAP_SLOTS);
        task.setUser(this.user);
        task.setConf((Configuration)taskConf);
        TaskTracker taskTracker2 = this.tt;
        taskTracker2.getClass();
        tip = new TaskTracker.TaskInProgress(taskTracker2, (Task)task, taskConf);
        TaskRunner taskRunner2 = task.createRunner(this.tt, tip, rjob);
        Vector<String> vargs2 = new Vector<String>(1);
        vargs2.add(this.writeScript("LS", "ls", pidFile).getAbsolutePath());
        File workDir2 = new File(TEST_DIR, "work2");
        File stdout2 = new File(TEST_DIR, "stdout2");
        File stderr2 = new File(TEST_DIR, "stderr2");
        taskRunner2.launchJvmAndWait(null, null, vargs2, stdout2, stderr2, 100L, workDir2);
        killer.join();
        jvmRunner.join();
        launcher.join();
        Assert.assertFalse((String)"Thread caught unexpected IOException", (boolean)this.threadCaughtException);
    }

    private void setThreadCaughtException() {
        this.threadCaughtException = true;
    }
}

