/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestEmptyJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestJobDirCleanup
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestEmptyJob.class.getName());

    private void runSleepJob(JobConf conf) throws Exception {
        String[] args = new String[]{"-m", "1", "-r", "10", "-mt", "1000", "-rt", "10000"};
        ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobDirCleanup() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            int taskTrackers = 10;
            int jobTrackerPort = 60050;
            Configuration conf = new Configuration();
            JobConf mrConf = new JobConf();
            mrConf.set("mapred.tasktracker.reduce.tasks.maximum", "1");
            dfs = new MiniDFSCluster(conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getUri().toString();
            mr = new MiniMRCluster(10, namenode, 3, null, null, mrConf);
            mr.setInlineCleanupThreads();
            String jobTrackerName = "localhost:" + mr.getJobTrackerPort();
            JobConf jobConf = mr.createJobConf();
            this.runSleepJob(jobConf);
            for (int i = 0; i < 10; ++i) {
                String jobDirStr = mr.getTaskTrackerLocalDir(i) + "/taskTracker/jobcache";
                File jobDir = new File(jobDirStr);
                String[] contents = jobDir.list();
                TestJobDirCleanup.assertTrue((String)("Contents of " + jobDir + " not cleanup."), (contents == null || contents.length == 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception ee) {
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

