/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.jobcontrol;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapred.jobcontrol.JobControlTestUtils;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;

public class TestJobControl
extends TestCase {
    public static void doJobControlTest() throws Exception {
        Configuration defaults = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)defaults);
        Path rootDataDir = new Path(System.getProperty("test.build.data", "."), "TestJobControlData");
        Path indir = new Path(rootDataDir, "indir");
        Path outdir_1 = new Path(rootDataDir, "outdir_1");
        Path outdir_2 = new Path(rootDataDir, "outdir_2");
        Path outdir_3 = new Path(rootDataDir, "outdir_3");
        Path outdir_4 = new Path(rootDataDir, "outdir_4");
        JobControlTestUtils.cleanData(fs, indir);
        JobControlTestUtils.generateData(fs, indir);
        JobControlTestUtils.cleanData(fs, outdir_1);
        JobControlTestUtils.cleanData(fs, outdir_2);
        JobControlTestUtils.cleanData(fs, outdir_3);
        JobControlTestUtils.cleanData(fs, outdir_4);
        ArrayList<Job> dependingJobs = null;
        ArrayList<Path> inPaths_1 = new ArrayList<Path>();
        inPaths_1.add(indir);
        JobConf jobConf_1 = JobControlTestUtils.createCopyJob(inPaths_1, outdir_1);
        Job job_1 = new Job(jobConf_1, dependingJobs);
        ArrayList<Path> inPaths_2 = new ArrayList<Path>();
        inPaths_2.add(indir);
        JobConf jobConf_2 = JobControlTestUtils.createCopyJob(inPaths_2, outdir_2);
        Job job_2 = new Job(jobConf_2, dependingJobs);
        ArrayList<Path> inPaths_3 = new ArrayList<Path>();
        inPaths_3.add(outdir_1);
        inPaths_3.add(outdir_2);
        JobConf jobConf_3 = JobControlTestUtils.createCopyJob(inPaths_3, outdir_3);
        dependingJobs = new ArrayList<Job>();
        dependingJobs.add(job_1);
        dependingJobs.add(job_2);
        Job job_3 = new Job(jobConf_3, dependingJobs);
        ArrayList<Path> inPaths_4 = new ArrayList<Path>();
        inPaths_4.add(outdir_3);
        JobConf jobConf_4 = JobControlTestUtils.createCopyJob(inPaths_4, outdir_4);
        dependingJobs = new ArrayList();
        dependingJobs.add(job_3);
        Job job_4 = new Job(jobConf_4, dependingJobs);
        JobControl theControl = new JobControl("Test");
        theControl.addJob((ControlledJob)job_1);
        theControl.addJob((ControlledJob)job_2);
        theControl.addJob((ControlledJob)job_3);
        theControl.addJob((ControlledJob)job_4);
        Thread theController = new Thread((Runnable)theControl);
        theController.start();
        while (!theControl.allFinished()) {
            System.out.println("Jobs in waiting state: " + theControl.getWaitingJobs().size());
            System.out.println("Jobs in ready state: " + theControl.getReadyJobs().size());
            System.out.println("Jobs in running state: " + theControl.getRunningJobs().size());
            System.out.println("Jobs in success state: " + theControl.getSuccessfulJobs().size());
            System.out.println("Jobs in failed state: " + theControl.getFailedJobs().size());
            System.out.println("\n");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {}
        }
        System.out.println("Jobs are all done???");
        System.out.println("Jobs in waiting state: " + theControl.getWaitingJobs().size());
        System.out.println("Jobs in ready state: " + theControl.getReadyJobs().size());
        System.out.println("Jobs in running state: " + theControl.getRunningJobs().size());
        System.out.println("Jobs in success state: " + theControl.getSuccessfulJobs().size());
        System.out.println("Jobs in failed state: " + theControl.getFailedJobs().size());
        System.out.println("\n");
        if (job_1.getState() != 4 && job_1.getState() != 5 && job_1.getState() != 0) {
            String states = "job_1:  " + job_1.getState() + "\n";
            throw new Exception("The state of job_1 is not in a complete state\n" + states);
        }
        if (job_2.getState() != 4 && job_2.getState() != 5 && job_2.getState() != 0) {
            String states = "job_2:  " + job_2.getState() + "\n";
            throw new Exception("The state of job_2 is not in a complete state\n" + states);
        }
        if (job_3.getState() != 4 && job_3.getState() != 5 && job_3.getState() != 0) {
            String states = "job_3:  " + job_3.getState() + "\n";
            throw new Exception("The state of job_3 is not in a complete state\n" + states);
        }
        if (job_4.getState() != 4 && job_4.getState() != 5 && job_4.getState() != 0) {
            String states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The state of job_4 is not in a complete state\n" + states);
        }
        if ((job_1.getState() == 4 || job_2.getState() == 4 || job_1.getState() == 5 || job_2.getState() == 5) && job_3.getState() != 5) {
            String states = "job_1:  " + job_1.getState() + "\n";
            states = "job_2:  " + job_2.getState() + "\n";
            states = "job_3:  " + job_3.getState() + "\n";
            states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The states of jobs 1, 2, 3, 4 are not consistent\n" + states);
        }
        if ((job_3.getState() == 4 || job_3.getState() == 5) && job_4.getState() != 5) {
            String states = "job_3:  " + job_3.getState() + "\n";
            states = "job_4:  " + job_4.getState() + "\n";
            throw new Exception("The states of jobs 3, 4 are not consistent\n" + states);
        }
        theControl.stop();
    }

    public void testJobControl() throws Exception {
        TestJobControl.doJobControlTest();
    }

    public static void main(String[] args) {
        TestJobControl test = new TestJobControl();
        try {
            test.testJobControl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

