/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestJvmManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskClasspathPrecedence {
    private static File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestJvmManager.class.getSimpleName());
    private static int MAP_SLOTS = 1;
    private static int REDUCE_SLOTS = 1;
    private TaskTracker tt;
    private JvmManager jvmManager;
    private JobConf ttConf = new JobConf();

    @Before
    public void setUp() {
        TEST_DIR.mkdirs();
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    public TestTaskClasspathPrecedence() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.ttConf);
        this.ttConf.setJar("build/test/testjar.jar");
        Path dfsPath = new Path("build/test/lib/testjob.jar");
        fs.copyFromLocalFile(new Path("build/test/testjar/testjob.jar"), dfsPath);
        this.tt = new TaskTracker();
        this.tt.setConf(new JobConf());
        this.tt.setMaxMapSlots(MAP_SLOTS);
        this.tt.setMaxReduceSlots(REDUCE_SLOTS);
        this.jvmManager = new JvmManager(this.tt);
        this.tt.setJvmManagerInstance(this.jvmManager);
    }

    @Test
    public void testWithClasspathPrecedence() throws Throwable {
        this.ttConf.set("mapreduce.task.classpath.user.precedence", "true");
        JobConf taskConf = new JobConf((Configuration)this.ttConf);
        TaskTracker.RunningJob rjob = new TaskTracker.RunningJob(new JobID("jt", 1));
        TaskAttemptID attemptID = new TaskAttemptID("test", 0, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, MAP_SLOTS);
        task.setConf((Configuration)taskConf);
        TaskTracker taskTracker = this.tt;
        taskTracker.getClass();
        TaskTracker.TaskInProgress tip = new TaskTracker.TaskInProgress(taskTracker, (Task)task, taskConf);
        MyTaskRunner taskRunner = new MyTaskRunner(tip, this.tt, taskConf, rjob);
        File workDir = new File(TEST_DIR, "work");
        workDir.mkdir();
        List classPaths = TaskRunner.getClassPaths((JobConf)taskConf, (File)workDir, null);
        Vector vargs = taskRunner.getVMArgs(task.getTaskID(), workDir, classPaths, 100L);
        String classpath = (String)vargs.get(2);
        String[] cp = classpath.split(":");
        Assert.assertTrue((String)cp[0], (boolean)cp[0].contains("testjob"));
    }

    @Test
    public void testWithoutClasspathPrecedence() throws Throwable {
        this.ttConf.set("mapreduce.task.classpath.user.precedence", "false");
        JobConf taskConf = new JobConf((Configuration)this.ttConf);
        TaskTracker.RunningJob rjob = new TaskTracker.RunningJob(new JobID("jt", 1));
        TaskAttemptID attemptID = new TaskAttemptID("test", 0, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, MAP_SLOTS);
        task.setConf((Configuration)taskConf);
        TaskTracker taskTracker = this.tt;
        taskTracker.getClass();
        TaskTracker.TaskInProgress tip = new TaskTracker.TaskInProgress(taskTracker, (Task)task, taskConf);
        MyTaskRunner taskRunner = new MyTaskRunner(tip, this.tt, taskConf, rjob);
        File workDir = new File(TEST_DIR, "work");
        workDir.mkdir();
        List classPaths = TaskRunner.getClassPaths((JobConf)taskConf, (File)workDir, null);
        Vector vargs = taskRunner.getVMArgs(task.getTaskID(), workDir, classPaths, 100L);
        String classpath = (String)vargs.get(2);
        String[] cp = classpath.split(":");
        Assert.assertFalse((String)cp[0], (boolean)cp[0].contains("testjob"));
    }

    private static class MyTaskRunner
    extends TaskRunner {
        private static String SYSTEM_PATH_SEPARATOR = System.getProperty("path.separator");

        public MyTaskRunner(TaskTracker.TaskInProgress tip, TaskTracker tracker, JobConf conf, TaskTracker.RunningJob job) throws IOException {
            super(tip, tracker, conf, job);
        }

        private Vector<String> getVMArgs(TaskAttemptID taskid, File workDir, List<String> classPaths, long logSize) throws IOException {
            Vector<String> vargs = new Vector<String>(8);
            File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
            vargs.add(jvm.toString());
            vargs.add("-classpath");
            String classPath = StringUtils.join((CharSequence)SYSTEM_PATH_SEPARATOR, classPaths);
            vargs.add(classPath);
            return vargs;
        }

        public Level getLogLevel(JobConf jobConf) {
            return Level.ALL;
        }
    }
}

