/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.Test;

public class TestMRJobClient
extends ClusterMapReduceTestCase {
    @Test
    public void testMissingProfileOutput() throws Exception {
        JobConf conf = this.createJobConf();
        String input = "hello1\n";
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "hello1\n");
        job.setJobName("disable-profile-fetch");
        JobConf jobConf = (JobConf)job.getConfiguration();
        jobConf.setProfileEnabled(true);
        jobConf.setProfileParams("-agentlib:,verbose=n,file=%s");
        jobConf.setMaxMapAttempts(1);
        jobConf.setMaxReduceAttempts(1);
        job.waitForCompletion(true);
        Job job2 = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "hello1\n");
        JobConf jobConf2 = (JobConf)job2.getConfiguration();
        job2.setJobName("enable-profile-fetch");
        jobConf2.setProfileEnabled(true);
        jobConf2.setProfileParams("-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s");
        jobConf2.setProfileTaskRange(true, "0-1");
        jobConf2.setProfileTaskRange(false, "");
        jobConf2.setMaxMapAttempts(1);
        jobConf2.setMaxReduceAttempts(1);
        job2.waitForCompletion(true);
        TaskCompletionEvent[] completionEvents = job2.getTaskCompletionEvents(0);
        TaskAttemptID attemptId = null;
        for (TaskCompletionEvent event : completionEvents) {
            if (!event.isMapTask()) continue;
            attemptId = event.getTaskAttemptId();
            break;
        }
        TestMRJobClient.assertNotNull((String)"Could not find a map task attempt", attemptId);
        File profileOutFile = new File(attemptId.toString() + ".profile");
        TestMRJobClient.assertTrue((String)"Couldn't find profiler output", (boolean)profileOutFile.exists());
        TestMRJobClient.assertTrue((String)"Couldn't remove profiler output", (boolean)profileOutFile.delete());
    }
}

