/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordComparator;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.Utils;
import org.apache.hadoop.record.meta.FieldTypeInfo;
import org.apache.hadoop.record.meta.RecordTypeInfo;
import org.apache.hadoop.record.meta.TypeID;

public class RecBuffer
extends Record {
    private static final RecordTypeInfo _rio_recTypeInfo = new RecordTypeInfo("RecBuffer");
    private static RecordTypeInfo _rio_rtiFilter;
    private static int[] _rio_rtiFilterFields;
    private Buffer data;

    public RecBuffer() {
    }

    public RecBuffer(Buffer data) {
        this.data = data;
    }

    public static RecordTypeInfo getTypeInfo() {
        return _rio_recTypeInfo;
    }

    public static void setTypeFilter(RecordTypeInfo rti) {
        if (null == rti) {
            return;
        }
        _rio_rtiFilter = rti;
        _rio_rtiFilterFields = null;
    }

    private static void setupRtiFields() {
        int _rio_i;
        if (null == _rio_rtiFilter) {
            return;
        }
        if (null != _rio_rtiFilterFields) {
            return;
        }
        _rio_rtiFilterFields = new int[_rio_rtiFilter.getFieldTypeInfos().size()];
        for (_rio_i = 0; _rio_i < _rio_rtiFilterFields.length; ++_rio_i) {
            RecBuffer._rio_rtiFilterFields[_rio_i] = 0;
        }
        Iterator _rio_itFilter = _rio_rtiFilter.getFieldTypeInfos().iterator();
        _rio_i = 0;
        while (_rio_itFilter.hasNext()) {
            FieldTypeInfo _rio_tInfoFilter = (FieldTypeInfo)_rio_itFilter.next();
            Iterator _rio_it = _rio_recTypeInfo.getFieldTypeInfos().iterator();
            int _rio_j = 1;
            while (_rio_it.hasNext()) {
                FieldTypeInfo _rio_tInfo = (FieldTypeInfo)_rio_it.next();
                if (_rio_tInfo.equals(_rio_tInfoFilter)) {
                    RecBuffer._rio_rtiFilterFields[_rio_i] = _rio_j;
                    break;
                }
                ++_rio_j;
            }
            ++_rio_i;
        }
    }

    public Buffer getData() {
        return this.data;
    }

    public void setData(Buffer data) {
        this.data = data;
    }

    public void serialize(RecordOutput _rio_a, String _rio_tag) throws IOException {
        _rio_a.startRecord((Record)this, _rio_tag);
        _rio_a.writeBuffer(this.data, "data");
        _rio_a.endRecord((Record)this, _rio_tag);
    }

    private void deserializeWithoutFilter(RecordInput _rio_a, String _rio_tag) throws IOException {
        _rio_a.startRecord(_rio_tag);
        this.data = _rio_a.readBuffer("data");
        _rio_a.endRecord(_rio_tag);
    }

    public void deserialize(RecordInput _rio_a, String _rio_tag) throws IOException {
        if (null == _rio_rtiFilter) {
            this.deserializeWithoutFilter(_rio_a, _rio_tag);
            return;
        }
        _rio_a.startRecord(_rio_tag);
        RecBuffer.setupRtiFields();
        for (int _rio_i = 0; _rio_i < _rio_rtiFilter.getFieldTypeInfos().size(); ++_rio_i) {
            if (1 == _rio_rtiFilterFields[_rio_i]) {
                this.data = _rio_a.readBuffer("data");
                continue;
            }
            ArrayList typeInfos = (ArrayList)_rio_rtiFilter.getFieldTypeInfos();
            org.apache.hadoop.record.meta.Utils.skip((RecordInput)_rio_a, (String)((FieldTypeInfo)typeInfos.get(_rio_i)).getFieldID(), (TypeID)((FieldTypeInfo)typeInfos.get(_rio_i)).getTypeID());
        }
        _rio_a.endRecord(_rio_tag);
    }

    public int compareTo(Object _rio_peer_) throws ClassCastException {
        if (!(_rio_peer_ instanceof RecBuffer)) {
            throw new ClassCastException("Comparing different types of records.");
        }
        RecBuffer _rio_peer = (RecBuffer)((Object)_rio_peer_);
        int _rio_ret = 0;
        _rio_ret = this.data.compareTo((Object)_rio_peer.data);
        if (_rio_ret != 0) {
            return _rio_ret;
        }
        return _rio_ret;
    }

    public boolean equals(Object _rio_peer_) {
        if (!(_rio_peer_ instanceof RecBuffer)) {
            return false;
        }
        if (_rio_peer_ == this) {
            return true;
        }
        RecBuffer _rio_peer = (RecBuffer)((Object)_rio_peer_);
        boolean _rio_ret = false;
        _rio_ret = this.data.equals((Object)_rio_peer.data);
        if (!_rio_ret) {
            return _rio_ret;
        }
        return _rio_ret;
    }

    public Object clone() throws CloneNotSupportedException {
        RecBuffer _rio_other = new RecBuffer();
        _rio_other.data = (Buffer)this.data.clone();
        return _rio_other;
    }

    public int hashCode() {
        int _rio_result = 17;
        int _rio_ret = this.data.hashCode();
        _rio_result = 37 * _rio_result + _rio_ret;
        return _rio_result;
    }

    public static String signature() {
        return "LRecBuffer(B)";
    }

    static {
        _rio_recTypeInfo.addField("data", TypeID.BufferTypeID);
        RecordComparator.define(RecBuffer.class, (RecordComparator)new Comparator());
    }

    public static class Comparator
    extends RecordComparator {
        public Comparator() {
            super(RecBuffer.class);
        }

        public static int slurpRaw(byte[] b, int s, int l) {
            try {
                int os = s;
                int i = Utils.readVInt((byte[])b, (int)s);
                int z = Utils.getVIntSize((long)i);
                l -= z + i;
                return os - (s += z + i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static int compareRaw(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int os1 = s1;
                int i1 = Utils.readVInt((byte[])b1, (int)s1);
                int i2 = Utils.readVInt((byte[])b2, (int)s2);
                int z1 = Utils.getVIntSize((long)i1);
                int z2 = Utils.getVIntSize((long)i2);
                l1 -= z1;
                l2 -= z2;
                int r1 = Utils.compareBytes((byte[])b1, (int)(s1 += z1), (int)i1, (byte[])b2, (int)(s2 += z2), (int)i2);
                if (r1 != 0) {
                    return r1 < 0 ? -1 : 0;
                }
                s2 += i2;
                l1 -= i1;
                l1 -= i2;
                return os1 - (s1 += i1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int ret = Comparator.compareRaw(b1, s1, l1, b2, s2, l2);
            return ret == -1 ? -1 : (ret == 0 ? 1 : 0);
        }
    }
}

