/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;

public class TestTaskStatus
extends TestCase {
    public void testMapTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(true);
    }

    public void testReduceTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(false);
    }

    private void checkTaskStatues(boolean isMap) {
        Object status = null;
        status = isMap ? new MapTaskStatus() : new ReduceTaskStatus();
        long currentTime = System.currentTimeMillis();
        status.setFinishTime(currentTime);
        TestTaskStatus.assertEquals((String)"Finish time of the task status set without start time", (long)0L, (long)status.getFinishTime());
        status.setStartTime(currentTime);
        TestTaskStatus.assertEquals((String)"Start time of the task status not set correctly.", (long)currentTime, (long)status.getStartTime());
        long wrongTime = -1L;
        status.setStartTime(wrongTime);
        TestTaskStatus.assertEquals((String)"Start time of the task status is set to wrong negative value", (long)currentTime, (long)status.getStartTime());
        status.setFinishTime(wrongTime);
        TestTaskStatus.assertEquals((String)"Finish time of task status is set to wrong negative value", (long)0L, (long)status.getFinishTime());
        status.setFinishTime(currentTime);
        TestTaskStatus.assertEquals((String)"Finish time of the task status not set correctly.", (long)currentTime, (long)status.getFinishTime());
    }
}

