/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDelegationTokenRenewal {
    private static final Log LOG = LogFactory.getLog(TestDelegationTokenRenewal.class);
    private static Configuration conf;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        InetAddress iaddr = InetAddress.getByName("localhost");
        String localhostDnsName = iaddr.getCanonicalHostName();
        URI uri = new URI("hdfs://" + localhostDnsName + ":0");
        System.out.println("scheme is : " + uri.getScheme());
        conf.setClass("fs." + uri.getScheme() + ".impl", MyFS.class, DistributedFileSystem.class);
        FileSystem.setDefaultUri((Configuration)conf, (URI)uri);
        System.out.println("filesystem uri = " + FileSystem.getDefaultUri((Configuration)conf).toString());
    }

    static MyToken createTokens(Text renewer) throws IOException {
        Text user1 = new Text("user1");
        MyDelegationTokenSecretManager sm = new MyDelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, null);
        sm.startThreads();
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(user1, renewer, user1);
        MyToken token1 = new MyToken(dtId1, sm);
        token1.setService(new Text("localhost:0"));
        return token1;
    }

    @Test
    public void testDTRenewal() throws IOException, URISyntaxException {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        System.out.println("dfs=" + (Object)((Object)dfs));
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        MyToken token2 = dfs.getDelegationToken(new Text("user2"));
        MyToken token3 = dfs.getDelegationToken(new Text("user3"));
        dfs.setTokenToRenewIn2Sec(token1);
        System.out.println("token=" + (Object)((Object)token1) + " should be renewed for 2 secs");
        String nn1 = "hdfs://host1:0";
        String nn2 = "hdfs://host2:0";
        String nn3 = "hdfs://host3:0";
        Credentials ts = new Credentials();
        ts.addToken(new Text(nn1), (Token)token1);
        ts.addToken(new Text(nn2), (Token)token2);
        ts.addToken(new Text(nn3), (Token)token3);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)new JobID("job1", 1), (Credentials)ts, (Configuration)conf);
        int numberOfExpectedRenewals = 4;
        int attempts = 10;
        while (attempts-- > 0) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (dfs.getCounter() != numberOfExpectedRenewals) continue;
        }
        System.out.println("Counter = " + dfs.getCounter() + ";t=" + (Object)((Object)dfs.getToken()));
        Assert.assertEquals((String)"renew wasn't called as many times as expected(4):", (long)numberOfExpectedRenewals, (long)dfs.getCounter());
        Assert.assertEquals((String)"most recently renewed token mismatch", (Object)((Object)dfs.getToken()), (Object)((Object)token1));
        ts = new Credentials();
        MyToken token4 = dfs.getDelegationToken(new Text("user4"));
        dfs.setTokenToRenewIn2Sec(token4);
        System.out.println("token=" + (Object)((Object)token4) + " should be renewed for 2 secs");
        String nn4 = "hdfs://host4:0";
        ts.addToken(new Text(nn4), (Token)token4);
        JobID jid2 = new JobID("job2", 1);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)jid2, (Credentials)ts, (Configuration)conf);
        DelegationTokenRenewal.removeDelegationTokenRenewalForJob((JobID)jid2);
        numberOfExpectedRenewals = dfs.getCounter();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("Counter = " + dfs.getCounter() + ";t=" + (Object)((Object)dfs.getToken()));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)dfs.getCounter());
        boolean exception = false;
        try {
            dfs.renewDelegationToken(token4);
        }
        catch (SecretManager.InvalidToken ite) {
            exception = true;
        }
        Assert.assertTrue((String)"Renew of canceled token didn't fail", (boolean)exception);
    }

    static class MyFS
    extends DistributedFileSystem {
        volatile int counter = 0;
        MyToken token;
        MyToken tokenToRenewIn2Sec;

        public void close() {
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
        }

        public long renewDelegationToken(Token<DelegationTokenIdentifier> t) throws SecretManager.InvalidToken, IOException {
            MyToken token = (MyToken)t;
            if (token.isCanceled()) {
                throw new SecretManager.InvalidToken("token has been canceled");
            }
            ++this.counter;
            this.token = token;
            System.out.println("Called MYDFS.renewdelegationtoken " + (Object)((Object)token));
            if (this.tokenToRenewIn2Sec == token) {
                System.out.println("RENEW in 2 seconds");
                this.tokenToRenewIn2Sec = null;
                return 2000L + System.currentTimeMillis();
            }
            return 86400000L + System.currentTimeMillis();
        }

        public MyToken getDelegationToken(Text renewer) throws IOException {
            System.out.println("Called MYDFS.getdelegationtoken");
            return TestDelegationTokenRenewal.createTokens(renewer);
        }

        public void cancelDelegationToken(Token<DelegationTokenIdentifier> t) throws IOException {
            MyToken token = (MyToken)t;
            token.cancelToken();
        }

        public void setTokenToRenewIn2Sec(MyToken t) {
            this.tokenToRenewIn2Sec = t;
        }

        public int getCounter() {
            return this.counter;
        }

        public MyToken getToken() {
            return this.token;
        }
    }

    private static class MyToken
    extends Token<DelegationTokenIdentifier> {
        public String status = "GOOD";
        public static final String CANCELED = "CANCELED";

        public MyToken(DelegationTokenIdentifier dtId1, MyDelegationTokenSecretManager sm) {
            super((TokenIdentifier)dtId1, (SecretManager)sm);
        }

        public boolean isCanceled() {
            return this.status.equals(CANCELED);
        }

        public void cancelToken() {
            this.status = CANCELED;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("id=");
            String id = StringUtils.byteToHexString((byte[])this.getIdentifier());
            int idLen = id.length();
            sb.append(id.substring(idLen - 6));
            sb.append(";k=");
            sb.append(this.getKind());
            sb.append(";s=");
            sb.append(this.getService());
            return sb.toString();
        }
    }

    private static class MyDelegationTokenSecretManager
    extends DelegationTokenSecretManager {
        public MyDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, namesystem);
        }

        public void logUpdateMasterKey(DelegationKey key) throws IOException {
        }
    }
}

