/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UserLogCleaner;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.server.tasktracker.Localizer;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobCompletedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestUserLogCleanup {
    private static String jtid = "test";
    private static long ONE_HOUR = 3600000L;
    private Localizer localizer;
    private UserLogManager userLogManager;
    private UserLogCleaner userLogCleaner;
    private TaskTracker tt;
    private UtilsForTests.FakeClock myClock;
    private JobID jobid1 = new JobID(jtid, 1);
    private JobID jobid2 = new JobID(jtid, 2);
    private JobID jobid3 = new JobID(jtid, 3);
    private JobID jobid4 = new JobID(jtid, 4);
    private File foo = new File(TaskLog.getUserLogDir(), "foo");
    private File bar = new File(TaskLog.getUserLogDir(), "bar");

    public TestUserLogCleanup() throws IOException {
        Configuration conf = new Configuration();
        this.startTT(conf);
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TaskLog.getUserLogDir());
    }

    private File localizeJob(JobID jobid) throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        new JobLocalizer(this.tt.getJobConf(), user, jobid.toString()).initializeJobLogDir();
        File jobUserlog = TaskLog.getJobDir((org.apache.hadoop.mapreduce.JobID)jobid);
        JobConf conf = new JobConf();
        this.tt.saveLogDir(jobid, conf);
        Assert.assertTrue((String)(jobUserlog + " directory is not created."), (boolean)jobUserlog.exists());
        return jobUserlog;
    }

    private void jobFinished(JobID jobid, int logRetainHours) {
        JobCompletedEvent jce = new JobCompletedEvent((org.apache.hadoop.mapreduce.JobID)jobid, this.myClock.getTime(), logRetainHours);
        this.userLogManager.addLogEvent((UserLogEvent)jce);
    }

    private void startTT(Configuration conf) throws IOException {
        this.myClock = new UtilsForTests.FakeClock();
        this.tt = new TaskTracker();
        this.tt.setConf(new JobConf(conf));
        this.localizer = new Localizer(FileSystem.get((Configuration)conf), conf.getTrimmedStrings("mapred.local.dir"));
        this.tt.setLocalizer(this.localizer);
        this.userLogManager = new UtilsForTests.InLineUserLogManager(conf);
        this.userLogCleaner = this.userLogManager.getUserLogCleaner();
        this.userLogCleaner.setClock((Clock)this.myClock);
        this.tt.setUserLogManager(this.userLogManager);
        this.userLogManager.clearOldUserLogs(conf);
    }

    private void ttReinited() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("mapred.userlog.retain.hours", 3);
        this.userLogManager.clearOldUserLogs(conf);
    }

    private void ttRestarted() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("mapred.userlog.retain.hours", 3);
        this.startTT(conf);
    }

    @Test
    public void testJobLogCleanup() throws IOException {
        File jobUserlog1 = this.localizeJob(this.jobid1);
        File jobUserlog2 = this.localizeJob(this.jobid2);
        this.jobFinished(this.jobid1, 2);
        this.jobFinished(this.jobid2, 1);
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertTrue((String)(jobUserlog1 + " got deleted"), (boolean)jobUserlog1.exists());
        Assert.assertFalse((String)(jobUserlog2 + " still exists."), (boolean)jobUserlog2.exists());
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((String)(jobUserlog1 + " still exists."), (boolean)jobUserlog1.exists());
    }

    @Test
    public void testUserLogCleanup() throws IOException {
        File jobUserlog1 = this.localizeJob(this.jobid1);
        File jobUserlog2 = this.localizeJob(this.jobid2);
        File jobUserlog3 = this.localizeJob(this.jobid3);
        File jobUserlog4 = this.localizeJob(this.jobid4);
        this.foo.mkdirs();
        this.bar.createNewFile();
        this.jobFinished(this.jobid1, 2);
        this.myClock.advance(ONE_HOUR);
        this.ttReinited();
        Assert.assertFalse((boolean)this.foo.exists());
        Assert.assertFalse((boolean)this.bar.exists());
        Assert.assertTrue((boolean)jobUserlog1.exists());
        Assert.assertTrue((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((boolean)jobUserlog1.exists());
        Assert.assertTrue((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        jobUserlog3 = this.localizeJob(this.jobid3);
        this.jobFinished(this.jobid3, 3);
        jobUserlog4 = this.localizeJob(this.jobid4);
        this.myClock.advance(2L * ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((boolean)jobUserlog1.exists());
        Assert.assertFalse((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((boolean)jobUserlog1.exists());
        Assert.assertFalse((boolean)jobUserlog2.exists());
        Assert.assertFalse((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
    }

    @Test
    public void testUserLogCleanupAfterRestart() throws IOException {
        File jobUserlog1 = this.localizeJob(this.jobid1);
        File jobUserlog2 = this.localizeJob(this.jobid2);
        File jobUserlog3 = this.localizeJob(this.jobid3);
        File jobUserlog4 = this.localizeJob(this.jobid4);
        this.foo.mkdirs();
        this.bar.createNewFile();
        this.jobFinished(this.jobid1, 2);
        this.myClock.advance(ONE_HOUR);
        this.ttRestarted();
        Assert.assertFalse((boolean)this.foo.exists());
        Assert.assertFalse((boolean)this.bar.exists());
        Assert.assertTrue((boolean)jobUserlog1.exists());
        Assert.assertTrue((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertTrue((boolean)jobUserlog1.exists());
        Assert.assertTrue((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        jobUserlog3 = this.localizeJob(this.jobid3);
        this.jobFinished(this.jobid3, 3);
        jobUserlog4 = this.localizeJob(this.jobid4);
        this.myClock.advance(2L * ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((boolean)jobUserlog1.exists());
        Assert.assertFalse((boolean)jobUserlog2.exists());
        Assert.assertTrue((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
        this.myClock.advance(ONE_HOUR);
        this.userLogCleaner.processCompletedJobs();
        Assert.assertFalse((boolean)jobUserlog1.exists());
        Assert.assertFalse((boolean)jobUserlog2.exists());
        Assert.assertFalse((boolean)jobUserlog3.exists());
        Assert.assertTrue((boolean)jobUserlog4.exists());
    }
}

