/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.split.JobSplit;

public class FakeObjectUtilities {
    static final Log LOG = LogFactory.getLog(FakeObjectUtilities.class);
    private static String jtIdentifier = "test";
    private static int jobCounter;

    static short sendHeartBeat(JobTracker jt, TaskTrackerStatus status, boolean initialContact, String tracker, short responseId) throws IOException {
        if (status == null) {
            status = new TaskTrackerStatus(tracker, JobInProgress.convertTrackerNameToHostName((String)tracker));
        }
        jt.heartbeat(status, false, initialContact, false, responseId);
        responseId = (short)(responseId + 1);
        return responseId;
    }

    static void establishFirstContact(JobTracker jt, String tracker) throws IOException {
        FakeObjectUtilities.sendHeartBeat(jt, null, true, tracker, (short)0);
    }

    static class FakeJobInProgress
    extends JobInProgress {
        FakeJobInProgress(JobConf jobConf, JobTracker tracker) throws IOException {
            super(new JobID(jtIdentifier, ++jobCounter), jobConf, tracker);
        }

        public synchronized void initTasks() throws IOException {
            int i;
            this.maps = new TaskInProgress[this.numMapTasks];
            for (i = 0; i < this.numMapTasks; ++i) {
                this.maps[i] = new TaskInProgress(this.getJobID(), "test", JobSplit.EMPTY_TASK_SPLIT, this.jobtracker, this.getJobConf(), (JobInProgress)this, i, 1);
                this.nonLocalMaps.add(this.maps[i]);
            }
            this.reduces = new TaskInProgress[this.numReduceTasks];
            for (i = 0; i < this.numReduceTasks; ++i) {
                this.reduces[i] = new TaskInProgress(this.getJobID(), "test", this.numMapTasks, i, this.jobtracker, this.getJobConf(), (JobInProgress)this, 1);
                this.nonRunningReduces.add(this.reduces[i]);
            }
        }

        private TaskAttemptID findTask(String trackerName, String trackerHost, Collection<TaskInProgress> nonRunningTasks, Collection<TaskInProgress> runningTasks) throws IOException {
            TaskInProgress tip = null;
            Iterator<TaskInProgress> iter = nonRunningTasks.iterator();
            while (iter.hasNext()) {
                TaskInProgress t = iter.next();
                if (!t.isRunnable() || t.isRunning()) continue;
                runningTasks.add(t);
                iter.remove();
                tip = t;
                break;
            }
            if (tip == null && this.getJobConf().getSpeculativeExecution()) {
                TaskTrackerStatus tts = this.jobtracker.getTaskTrackerStatus(trackerName);
                tip = this.findSpeculativeTask(runningTasks, tts, this.status.mapProgress(), this.jobtracker.getClock().getTime(), true);
            }
            if (tip != null) {
                TaskAttemptID tId = tip.getTaskToRun(trackerName).getTaskID();
                if (tip.isMapTask()) {
                    this.scheduleMap(tip);
                } else {
                    this.scheduleReduce(tip);
                }
                this.makeRunning(tId, tip, trackerName);
                return tId;
            }
            return null;
        }

        public TaskAttemptID findMapTask(String trackerName) throws IOException {
            return this.findTask(trackerName, JobInProgress.convertTrackerNameToHostName((String)trackerName), this.nonLocalMaps, this.nonLocalRunningMaps);
        }

        public TaskAttemptID findReduceTask(String trackerName) throws IOException {
            return this.findTask(trackerName, JobInProgress.convertTrackerNameToHostName((String)trackerName), this.nonRunningReduces, this.runningReduces);
        }

        public void finishTask(TaskAttemptID taskId) {
            TaskInProgress tip = (TaskInProgress)this.jobtracker.taskidToTIPMap.get(taskId);
            TaskStatus status = TaskStatus.createTaskStatus((boolean)tip.isMapTask(), (TaskAttemptID)taskId, (float)1.0f, (int)1, (TaskStatus.State)TaskStatus.State.SUCCEEDED, (String)"", (String)"", (String)tip.machineWhereTaskRan(taskId), (TaskStatus.Phase)(tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE), (Counters)new Counters());
            this.updateTaskStatus(tip, status);
        }

        private void makeRunning(TaskAttemptID taskId, TaskInProgress tip, String taskTracker) {
            this.addRunningTaskToTIP(tip, taskId, new TaskTrackerStatus(taskTracker, JobInProgress.convertTrackerNameToHostName((String)taskTracker)), true);
            TaskStatus status = TaskStatus.createTaskStatus((boolean)tip.isMapTask(), (TaskAttemptID)taskId, (float)0.0f, (int)1, (TaskStatus.State)TaskStatus.State.RUNNING, (String)"", (String)"", (String)taskTracker, (TaskStatus.Phase)(tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE), (Counters)new Counters());
            this.updateTaskStatus(tip, status);
        }

        public void progressMade(TaskAttemptID taskId, float progress) {
            TaskInProgress tip = (TaskInProgress)this.jobtracker.taskidToTIPMap.get(taskId);
            TaskStatus status = TaskStatus.createTaskStatus((boolean)tip.isMapTask(), (TaskAttemptID)taskId, (float)progress, (int)1, (TaskStatus.State)TaskStatus.State.RUNNING, (String)"", (String)"", (String)tip.machineWhereTaskRan(taskId), (TaskStatus.Phase)(tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE), (Counters)new Counters());
            this.updateTaskStatus(tip, status);
        }
    }

    static class FakeJobTracker
    extends JobTracker {
        int totalSlots;
        private String[] trackers;

        FakeJobTracker(JobConf conf, Clock clock, String[] tts) throws IOException, InterruptedException {
            super(conf, clock);
            this.trackers = tts;
            this.totalSlots = this.trackers.length * 4;
        }

        public ClusterStatus getClusterStatus(boolean detailed) {
            return new ClusterStatus(this.trackers.length, 0, 0L, 0, 0, this.totalSlots / 2, this.totalSlots / 2, JobTracker.State.RUNNING, 0);
        }

        public void setNumSlots(int totalSlots) {
            this.totalSlots = totalSlots;
        }
    }
}

