/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.StreamUtil;

public class StreamInputFormat
extends KeyValueTextInputFormat {
    public RecordReader<Text, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        RecordReader reader;
        Constructor ctor;
        String c = job.get("stream.recordreader.class");
        if (c == null || c.indexOf("LineRecordReader") >= 0) {
            return super.getRecordReader(genericSplit, job, reporter);
        }
        FileSplit split = (FileSplit)genericSplit;
        LOG.info((Object)("getRecordReader start.....split=" + split));
        reporter.setStatus(split.toString());
        FileSystem fs = split.getPath().getFileSystem((Configuration)job);
        FSDataInputStream in = fs.open(split.getPath());
        Class readerClass = StreamUtil.goodClassOrNull((Configuration)job, (String)c, null);
        if (readerClass == null) {
            throw new RuntimeException("Class not found: " + c);
        }
        try {
            ctor = readerClass.getConstructor(FSDataInputStream.class, FileSplit.class, Reporter.class, JobConf.class, FileSystem.class);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm);
        }
        try {
            reader = (RecordReader)ctor.newInstance(in, split, reporter, job, fs);
        }
        catch (Exception nsm) {
            throw new RuntimeException(nsm);
        }
        return reader;
    }
}

