/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.streaming.DelayEchoApp;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStreamingBackground {
    protected File TEST_DIR = new File("target/TestStreamingBackground").getAbsoluteFile();
    protected File INPUT_FILE = new File(this.TEST_DIR, "input.txt");
    protected File OUTPUT_DIR = new File(this.TEST_DIR, "out");
    protected String tenSecondsTask = UtilTest.makeJavaCommand(DelayEchoApp.class, (String[])new String[]{"10"});
    protected String[] args = new String[]{"-background", "-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.tenSecondsTask, "-reducer", this.tenSecondsTask, "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-jobconf", "mapreduce.task.io.sort.mb=10"};

    public TestStreamingBackground() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    @Before
    public void setUp() throws IOException {
        UtilTest.recursiveDelete((File)this.TEST_DIR);
        Assert.assertTrue((boolean)this.TEST_DIR.mkdirs());
        FileOutputStream out = new FileOutputStream(this.INPUT_FILE.getAbsoluteFile());
        out.write("hello\n".getBytes());
        out.close();
    }

    public void runStreamJob() throws Exception {
        boolean mayExit = false;
        int returnStatus = 0;
        StreamJob job = new StreamJob(this.args, mayExit);
        returnStatus = job.go();
        Assert.assertEquals((String)"Streaming Job expected to succeed", (long)0L, (long)returnStatus);
        job.running_.killJob();
        job.running_.waitForCompletion();
    }

    @Test
    public void testBackgroundSubmitOk() throws Exception {
        this.runStreamJob();
    }
}

