/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.streaming.FailApp;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStreamingExitStatus {
    protected File TEST_DIR = new File("target/TestStreamingExitStatus").getAbsoluteFile();
    protected File INPUT_FILE = new File(this.TEST_DIR, "input.txt");
    protected File OUTPUT_DIR = new File(this.TEST_DIR, "out");
    protected String failingTask = UtilTest.makeJavaCommand(FailApp.class, (String[])new String[]{"true"});
    protected String echoTask = UtilTest.makeJavaCommand(FailApp.class, (String[])new String[]{"false"});

    public TestStreamingExitStatus() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected String[] genArgs(boolean exitStatusIsFailure, boolean failMap) {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", failMap ? this.failingTask : this.echoTask, "-reducer", failMap ? this.echoTask : this.failingTask, "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.non.zero.exit.is.failure=" + exitStatusIsFailure, "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-jobconf", "mapreduce.task.io.sort.mb=10"};
    }

    @Before
    public void setUp() throws IOException {
        UtilTest.recursiveDelete((File)this.TEST_DIR);
        Assert.assertTrue((boolean)this.TEST_DIR.mkdirs());
        FileOutputStream out = new FileOutputStream(this.INPUT_FILE.getAbsoluteFile());
        out.write("hello\n".getBytes());
        out.close();
    }

    public void runStreamJob(boolean exitStatusIsFailure, boolean failMap) throws Exception {
        boolean mayExit = false;
        int returnStatus = 0;
        StreamJob job = new StreamJob(this.genArgs(exitStatusIsFailure, failMap), mayExit);
        returnStatus = job.go();
        if (exitStatusIsFailure) {
            Assert.assertEquals((String)"Streaming Job failure code expected", (long)1L, (long)returnStatus);
        } else {
            Assert.assertEquals((String)"Streaming Job expected to succeed", (long)0L, (long)returnStatus);
        }
    }

    @Test
    public void testMapFailOk() throws Exception {
        this.runStreamJob(false, true);
    }

    @Test
    public void testMapFailNotOk() throws Exception {
        this.runStreamJob(true, true);
    }

    @Test
    public void testReduceFailOk() throws Exception {
        this.runStreamJob(false, false);
    }

    @Test
    public void testReduceFailNotOk() throws Exception {
        this.runStreamJob(true, false);
    }
}

