/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.AutoInputFormat;
import org.apache.hadoop.typedbytes.TypedBytesOutput;
import org.apache.hadoop.typedbytes.TypedBytesWritableOutput;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DumpTypedBytes
implements Tool {
    private Configuration conf;

    public DumpTypedBytes(Configuration conf) {
        this.conf = conf;
    }

    public DumpTypedBytes() {
        this(new Configuration());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Too few arguments!");
            this.printUsage();
            return 1;
        }
        Path pattern = new Path(args[0]);
        FileSystem fs = pattern.getFileSystem(this.getConf());
        fs.setVerifyChecksum(true);
        Path[] arr$ = FileUtil.stat2Paths((FileStatus[])fs.globStatus(pattern), (Path)pattern);
        int len$ = arr$.length;
        int i$ = 0;
        if (i$ < len$) {
            Path p = arr$[i$];
            ArrayList<FileStatus> inputFiles = new ArrayList<FileStatus>();
            FileStatus status = fs.getFileStatus(p);
            if (status.isDirectory()) {
                FileStatus[] files = fs.listStatus(p);
                Collections.addAll(inputFiles, files);
            } else {
                inputFiles.add(status);
            }
            return this.dumpTypedBytes(inputFiles);
        }
        return -1;
    }

    private void printUsage() {
        System.out.println("Usage: $HADOOP_PREFIX/bin/hadoop jar hadoop-streaming.jar dumptb <glob-pattern>");
        System.out.println("  Dumps all files that match the given pattern to standard output as typed bytes.");
        System.out.println("  The files can be text or sequence files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpTypedBytes(List<FileStatus> files) throws IOException {
        JobConf job = new JobConf(this.getConf());
        DataOutputStream dout = new DataOutputStream(System.out);
        AutoInputFormat autoInputFormat = new AutoInputFormat();
        for (FileStatus fileStatus : files) {
            FileSplit split = new FileSplit(fileStatus.getPath(), 0L, fileStatus.getLen() * fileStatus.getBlockSize(), (String[])null);
            RecordReader recReader = null;
            try {
                recReader = autoInputFormat.getRecordReader((InputSplit)split, job, Reporter.NULL);
                Object key = recReader.createKey();
                Object value = recReader.createValue();
                while (recReader.next(key, value)) {
                    if (key instanceof Writable) {
                        TypedBytesWritableOutput.get((DataOutput)dout).write((Writable)key);
                    } else {
                        TypedBytesOutput.get((DataOutput)dout).write(key);
                    }
                    if (value instanceof Writable) {
                        TypedBytesWritableOutput.get((DataOutput)dout).write((Writable)value);
                        continue;
                    }
                    TypedBytesOutput.get((DataOutput)dout).write(value);
                }
            }
            finally {
                if (recReader == null) continue;
                recReader.close();
            }
        }
        dout.flush();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        DumpTypedBytes dumptb = new DumpTypedBytes();
        int res = ToolRunner.run((Tool)dumptb, (String[])args);
        System.exit(res);
    }
}

