/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.util.LineReader;

public class KeyOnlyTextOutputReader
extends OutputReader<Text, NullWritable> {
    private LineReader lineReader;
    private byte[] bytes;
    private DataInput clientIn;
    private Configuration conf;
    private Text key;
    private Text line;

    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientIn = pipeMapRed.getClientInput();
        this.conf = pipeMapRed.getConfiguration();
        this.lineReader = new LineReader((InputStream)((Object)this.clientIn), this.conf);
        this.key = new Text();
        this.line = new Text();
    }

    public boolean readKeyValue() throws IOException {
        if (this.lineReader.readLine(this.line) <= 0) {
            return false;
        }
        this.bytes = this.line.getBytes();
        this.key.set(this.bytes, 0, this.line.getLength());
        this.line.clear();
        return true;
    }

    public Text getCurrentKey() throws IOException {
        return this.key;
    }

    public NullWritable getCurrentValue() throws IOException {
        return NullWritable.get();
    }

    public String getLastOutput() {
        if (this.bytes != null) {
            try {
                return new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "<undecodable>";
            }
        }
        return null;
    }
}

