/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SchedulerMetrics {
    protected ResourceScheduler scheduler;
    protected Set<String> trackedQueues;
    protected MetricRegistry metrics;
    protected Set<String> appTrackedMetrics = new HashSet();
    protected Set<String> queueTrackedMetrics;

    public SchedulerMetrics() {
        this.appTrackedMetrics.add("live.containers");
        this.appTrackedMetrics.add("reserved.containers");
        this.queueTrackedMetrics = new HashSet();
    }

    public void init(ResourceScheduler scheduler, MetricRegistry metrics) {
        this.scheduler = scheduler;
        this.trackedQueues = new HashSet();
        this.metrics = metrics;
    }

    public void trackApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        this.metrics.register("variable.app." + oldAppId + ".live.containers", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".reserved.containers", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void untrackApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        for (String m : this.appTrackedMetrics) {
            this.metrics.remove("variable.app." + oldAppId + "." + m);
        }
    }

    public abstract void trackQueue(String var1);

    public void untrackQueue(String queueName) {
        for (String m : this.queueTrackedMetrics) {
            this.metrics.remove("variable.queue." + queueName + "." + m);
        }
    }

    public boolean isTracked(String queueName) {
        return this.trackedQueues.contains(queueName);
    }

    public Set<String> getAppTrackedMetrics() {
        return this.appTrackedMetrics;
    }

    public Set<String> getQueueTrackedMetrics() {
        return this.queueTrackedMetrics;
    }
}

