/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.MappingIterator;
import org.codehaus.jackson.map.ObjectMapper;

public class SLSUtils {
    public static String[] getRackHostName(String hostname) {
        hostname = hostname.substring(1);
        return hostname.split("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromRumenTrace(String jobTrace) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        File fin = new File(jobTrace);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        JobTraceReader reader = new JobTraceReader(new Path(fin.getAbsolutePath()), conf);
        try {
            LoggedJob job = null;
            while ((job = (LoggedJob)reader.getNext()) != null) {
                LoggedTaskAttempt taskAttempt;
                for (LoggedTask mapTask : job.getMapTasks()) {
                    taskAttempt = (LoggedTaskAttempt)mapTask.getAttempts().get(mapTask.getAttempts().size() - 1);
                    nodeSet.add(taskAttempt.getHostName().getValue());
                }
                for (LoggedTask reduceTask : job.getReduceTasks()) {
                    taskAttempt = (LoggedTaskAttempt)reduceTask.getAttempts().get(reduceTask.getAttempts().size() - 1);
                    nodeSet.add(taskAttempt.getHostName().getValue());
                }
            }
        }
        finally {
            reader.close();
        }
        return nodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromSLSTrace(String jobTrace) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        FileReader input = new FileReader(jobTrace);
        try {
            MappingIterator i = mapper.readValues(jsonF.createJsonParser((Reader)input), Map.class);
            while (i.hasNext()) {
                Map jsonE = (Map)i.next();
                List tasks = (List)jsonE.get("job.tasks");
                for (Object o : tasks) {
                    Map jsonTask = (Map)o;
                    String hostname = jsonTask.get("container.host").toString();
                    nodeSet.add(hostname);
                }
            }
        }
        finally {
            ((Reader)input).close();
        }
        return nodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromNodeFile(String nodeFile) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        FileReader input = new FileReader(nodeFile);
        try {
            MappingIterator i = mapper.readValues(jsonF.createJsonParser((Reader)input), Map.class);
            while (i.hasNext()) {
                Map jsonE = (Map)i.next();
                String rack = "/" + jsonE.get("rack");
                List tasks = (List)jsonE.get("nodes");
                for (Object o : tasks) {
                    Map jsonNode = (Map)o;
                    nodeSet.add(rack + "/" + jsonNode.get("node"));
                }
            }
        }
        finally {
            ((Reader)input).close();
        }
        return nodeSet;
    }
}

