/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class TaskRunner {
    private DelayQueue queue = new DelayQueue();
    private int threadPoolSize;
    private ThreadPoolExecutor executor;
    private long startTimeMS = 0L;

    public void setQueueSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void start() {
        if (this.executor != null) {
            throw new IllegalStateException("Already started");
        }
        DelayQueue preStartQueue = this.queue;
        this.queue = new DelayQueue();
        this.executor = new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 0L, TimeUnit.MILLISECONDS, this.queue);
        this.executor.prestartAllCoreThreads();
        this.startTimeMS = System.currentTimeMillis();
        for (Object d : preStartQueue) {
            this.schedule((Task)d, this.startTimeMS);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private void schedule(Task task, long timeNow) {
        task.timeRebase(timeNow);
        task.setQueue(this.queue);
        this.queue.add(task);
    }

    public void schedule(Task task) {
        this.schedule(task, System.currentTimeMillis());
    }

    public long getStartTimeMS() {
        return this.startTimeMS;
    }

    public static abstract class Task
    implements Runnable,
    Delayed {
        private long start;
        private long end;
        private long nextRun;
        private long startTime;
        private long endTime;
        private long repeatInterval;
        private Queue<Task> queue;

        public void init(long startTime, long endTime, long repeatInterval) {
            if (endTime - startTime < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("endTime[{0}] cannot be smaller than startTime[{1}]", endTime, startTime));
            }
            if (repeatInterval < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("repeatInterval[{0}] cannot be less than 1", repeatInterval));
            }
            if ((endTime - startTime) % repeatInterval != 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid parameters: (endTime[{0}] - startTime[{1}]) % repeatInterval[{2}] != 0", endTime, startTime, repeatInterval));
            }
            this.start = startTime;
            this.end = endTime;
            this.repeatInterval = repeatInterval;
        }

        private void timeRebase(long now) {
            this.startTime = now + this.start;
            this.endTime = now + this.end;
            this.nextRun = this.startTime;
        }

        public void init(long startTime) {
            this.init(startTime, startTime, 1L);
        }

        private void setQueue(Queue<Task> queue) {
            this.queue = queue;
        }

        @Override
        public final void run() {
            try {
                if (this.nextRun == this.startTime) {
                    this.firstStep();
                    this.nextRun += this.repeatInterval;
                    if (this.nextRun <= this.endTime) {
                        this.queue.add(this);
                    }
                } else if (this.nextRun < this.endTime) {
                    this.middleStep();
                    this.nextRun += this.repeatInterval;
                    this.queue.add(this);
                } else {
                    this.lastStep();
                }
            }
            catch (YarnException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.nextRun - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (!(o instanceof Task)) {
                throw new IllegalArgumentException("Parameter must be a Task instance");
            }
            Task other = (Task)o;
            return (int)Math.signum(this.nextRun - other.nextRun);
        }

        public abstract void firstStep() throws YarnException, IOException, InterruptedException;

        public abstract void middleStep() throws YarnException, InterruptedException, IOException;

        public abstract void lastStep() throws YarnException;

        public void setEndTime(long et) {
            this.endTime = et;
        }
    }
}

