/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.log4j.Logger;

public class MRAMSimulator
extends AMSimulator {
    private static final int PRIORITY_REDUCE = 10;
    private static final int PRIORITY_MAP = 20;
    private LinkedList<ContainerSimulator> pendingMaps = new LinkedList();
    private LinkedList<ContainerSimulator> pendingFailedMaps = new LinkedList();
    private LinkedList<ContainerSimulator> scheduledMaps = new LinkedList();
    private Map<ContainerId, ContainerSimulator> assignedMaps = new HashMap<ContainerId, ContainerSimulator>();
    private LinkedList<ContainerSimulator> pendingReduces = new LinkedList();
    private LinkedList<ContainerSimulator> pendingFailedReduces = new LinkedList();
    private LinkedList<ContainerSimulator> scheduledReduces = new LinkedList();
    private Map<ContainerId, ContainerSimulator> assignedReduces = new HashMap<ContainerId, ContainerSimulator>();
    private LinkedList<ContainerSimulator> allMaps = new LinkedList();
    private LinkedList<ContainerSimulator> allReduces = new LinkedList();
    private int mapFinished = 0;
    private int mapTotal = 0;
    private int reduceFinished = 0;
    private int reduceTotal = 0;
    private boolean isAMContainerRunning = false;
    private Container amContainer;
    private boolean isFinished = false;
    private static final int MR_AM_CONTAINER_RESOURCE_MEMORY_MB = 1024;
    private static final int MR_AM_CONTAINER_RESOURCE_VCORES = 1;
    public final Logger LOG = Logger.getLogger(MRAMSimulator.class);

    @Override
    public void init(int id, int heartbeatInterval, List<ContainerSimulator> containerList, ResourceManager rm, SLSRunner se, long traceStartTime, long traceFinishTime, String user, String queue, boolean isTracked, String oldAppId) {
        super.init(id, heartbeatInterval, containerList, rm, se, traceStartTime, traceFinishTime, user, queue, isTracked, oldAppId);
        this.amtype = "mapreduce";
        for (ContainerSimulator cs : containerList) {
            if (cs.getType().equals("map")) {
                cs.setPriority(20);
                this.pendingMaps.add(cs);
                continue;
            }
            if (!cs.getType().equals("reduce")) continue;
            cs.setPriority(10);
            this.pendingReduces.add(cs);
        }
        this.allMaps.addAll(this.pendingMaps);
        this.allReduces.addAll(this.pendingReduces);
        this.mapTotal = this.pendingMaps.size();
        this.reduceTotal = this.pendingReduces.size();
        this.totalContainers = this.mapTotal + this.reduceTotal;
    }

    @Override
    public void firstStep() throws YarnException, IOException, InterruptedException {
        super.firstStep();
        this.requestAMContainer();
    }

    protected void requestAMContainer() throws YarnException, IOException, InterruptedException {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest amRequest = this.createResourceRequest(BuilderUtils.newResource((int)1024, (int)1), "*", 1, 1);
        ask.add(amRequest);
        this.LOG.debug((Object)MessageFormat.format("Application {0} sends out allocate request for its AM", this.appId));
        final AllocateRequest request = this.createAllocateRequest(ask);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId())).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        AllocateResponse response = (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

            @Override
            public AllocateResponse run() throws Exception {
                return MRAMSimulator.this.rm.getApplicationMasterService().allocate(request);
            }
        });
        while (true) {
            if (response != null && !response.getAllocatedContainers().isEmpty()) break;
            Thread.sleep(1000L);
            this.sendContainerRequest();
            response = (AllocateResponse)this.responseQueue.take();
        }
        Container container = (Container)response.getAllocatedContainers().get(0);
        this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, -1L);
        this.amContainer = container;
        this.LOG.debug((Object)MessageFormat.format("Application {0} starts its AM container ({1}).", this.appId, this.amContainer.getId()));
        this.isAMContainerRunning = true;
    }

    @Override
    protected void processResponseQueue() throws InterruptedException, YarnException, IOException {
        while (!this.responseQueue.isEmpty()) {
            AllocateResponse response = (AllocateResponse)this.responseQueue.take();
            if (!response.getCompletedContainersStatuses().isEmpty()) {
                for (ContainerStatus cs : response.getCompletedContainersStatuses()) {
                    ContainerId containerId = cs.getContainerId();
                    if (cs.getExitStatus() == 0) {
                        if (this.assignedMaps.containsKey(containerId)) {
                            this.LOG.debug((Object)MessageFormat.format("Application {0} has onemapper finished ({1}).", this.appId, containerId));
                            this.assignedMaps.remove(containerId);
                            ++this.mapFinished;
                            ++this.finishedContainers;
                            continue;
                        }
                        if (this.assignedReduces.containsKey(containerId)) {
                            this.LOG.debug((Object)MessageFormat.format("Application {0} has onereducer finished ({1}).", this.appId, containerId));
                            this.assignedReduces.remove(containerId);
                            ++this.reduceFinished;
                            ++this.finishedContainers;
                            continue;
                        }
                        this.isFinished = true;
                        this.LOG.info((Object)MessageFormat.format("Application {0} goes to finish.", this.appId));
                        continue;
                    }
                    if (this.assignedMaps.containsKey(containerId)) {
                        this.LOG.debug((Object)MessageFormat.format("Application {0} has one mapper killed ({1}).", this.appId, containerId));
                        this.pendingFailedMaps.add(this.assignedMaps.remove(containerId));
                        continue;
                    }
                    if (this.assignedReduces.containsKey(containerId)) {
                        this.LOG.debug((Object)MessageFormat.format("Application {0} has one reducer killed ({1}).", this.appId, containerId));
                        this.pendingFailedReduces.add(this.assignedReduces.remove(containerId));
                        continue;
                    }
                    this.LOG.info((Object)MessageFormat.format("Application {0}'s AM is going to be killed. Restarting...", this.appId));
                    this.restart();
                }
            }
            if (this.isAMContainerRunning && this.mapFinished == this.mapTotal && this.reduceFinished == this.reduceTotal) {
                this.se.getNmMap().get(this.amContainer.getNodeId()).cleanupContainer(this.amContainer.getId());
                this.isAMContainerRunning = false;
                this.LOG.debug((Object)MessageFormat.format("Application {0} sends out event to clean up its AM container.", this.appId));
                this.isFinished = true;
            }
            for (Container container : response.getAllocatedContainers()) {
                ContainerSimulator cs;
                if (!this.scheduledMaps.isEmpty()) {
                    cs = this.scheduledMaps.remove();
                    this.LOG.debug((Object)MessageFormat.format("Application {0} starts a launch a mapper ({1}).", this.appId, container.getId()));
                    this.assignedMaps.put(container.getId(), cs);
                    this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
                    continue;
                }
                if (this.scheduledReduces.isEmpty()) continue;
                cs = this.scheduledReduces.remove();
                this.LOG.debug((Object)MessageFormat.format("Application {0} starts a launch a reducer ({1}).", this.appId, container.getId()));
                this.assignedReduces.put(container.getId(), cs);
                this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
            }
        }
    }

    private void restart() throws YarnException, IOException, InterruptedException {
        this.finishedContainers = 0;
        this.isFinished = false;
        this.mapFinished = 0;
        this.reduceFinished = 0;
        this.pendingFailedMaps.clear();
        this.pendingMaps.clear();
        this.pendingReduces.clear();
        this.pendingFailedReduces.clear();
        this.pendingMaps.addAll(this.allMaps);
        this.pendingReduces.addAll(this.pendingReduces);
        this.isAMContainerRunning = false;
        this.amContainer = null;
        this.requestAMContainer();
    }

    @Override
    protected void sendContainerRequest() throws YarnException, IOException, InterruptedException {
        if (this.isFinished) {
            return;
        }
        List<Object> ask = null;
        if (this.isAMContainerRunning) {
            if (this.mapFinished != this.mapTotal) {
                if (!this.pendingMaps.isEmpty()) {
                    ask = this.packageRequests(this.pendingMaps, 20);
                    this.LOG.debug((Object)MessageFormat.format("Application {0} sends out request for {1} mappers.", this.appId, this.pendingMaps.size()));
                    this.scheduledMaps.addAll(this.pendingMaps);
                    this.pendingMaps.clear();
                } else if (!this.pendingFailedMaps.isEmpty() && this.scheduledMaps.isEmpty()) {
                    ask = this.packageRequests(this.pendingFailedMaps, 20);
                    this.LOG.debug((Object)MessageFormat.format("Application {0} sends out requests for {1} failed mappers.", this.appId, this.pendingFailedMaps.size()));
                    this.scheduledMaps.addAll(this.pendingFailedMaps);
                    this.pendingFailedMaps.clear();
                }
            } else if (this.reduceFinished != this.reduceTotal) {
                if (!this.pendingReduces.isEmpty()) {
                    ask = this.packageRequests(this.pendingReduces, 10);
                    this.LOG.debug((Object)MessageFormat.format("Application {0} sends out requests for {1} reducers.", this.appId, this.pendingReduces.size()));
                    this.scheduledReduces.addAll(this.pendingReduces);
                    this.pendingReduces.clear();
                } else if (!this.pendingFailedReduces.isEmpty() && this.scheduledReduces.isEmpty()) {
                    ask = this.packageRequests(this.pendingFailedReduces, 10);
                    this.LOG.debug((Object)MessageFormat.format("Application {0} sends out request for {1} failed reducers.", this.appId, this.pendingFailedReduces.size()));
                    this.scheduledReduces.addAll(this.pendingFailedReduces);
                    this.pendingFailedReduces.clear();
                }
            }
        }
        if (ask == null) {
            ask = new ArrayList();
        }
        final AllocateRequest request = this.createAllocateRequest(ask);
        if (this.totalContainers == 0) {
            request.setProgress(1.0f);
        } else {
            request.setProgress((float)this.finishedContainers / (float)this.totalContainers);
        }
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId())).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        AllocateResponse response = (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

            @Override
            public AllocateResponse run() throws Exception {
                return MRAMSimulator.this.rm.getApplicationMasterService().allocate(request);
            }
        });
        if (response != null) {
            this.responseQueue.put(response);
        }
    }

    @Override
    protected void checkStop() {
        if (this.isFinished) {
            super.setEndTime(System.currentTimeMillis());
        }
    }

    @Override
    public void lastStep() {
        super.lastStep();
        this.allMaps.clear();
        this.allReduces.clear();
        this.assignedMaps.clear();
        this.assignedReduces.clear();
        this.pendingFailedMaps.clear();
        this.pendingFailedReduces.clear();
        this.pendingMaps.clear();
        this.pendingReduces.clear();
        this.scheduledMaps.clear();
        this.scheduledReduces.clear();
        this.responseQueue.clear();
    }
}

