/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Node
implements Comparable<Node> {
    private static final SortedSet<Node> EMPTY_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private Node parent;
    private final String name;
    private final int level;
    private SortedSet<Node> children;

    public Node(String name, int level) {
        if (name == null) {
            throw new IllegalArgumentException("Node name cannot be null");
        }
        if (level < 0) {
            throw new IllegalArgumentException("Level cannot be negative");
        }
        this.name = name;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    private void checkChildren() {
        if (this.children == null) {
            this.children = new TreeSet();
        }
    }

    public synchronized boolean addChild(Node child) {
        if (child.parent != null) {
            throw new IllegalArgumentException("The child is already under another node:" + child.parent);
        }
        this.checkChildren();
        boolean retval = this.children.add(child);
        if (retval) {
            child.parent = this;
        }
        return retval;
    }

    public synchronized boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public synchronized Set<Node> getChildren() {
        return this.children == null ? EMPTY_SET : Collections.unmodifiableSortedSet(this.children);
    }

    public Node getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return "(" + this.name + ", " + this.level + ")";
    }

    @Override
    public int compareTo(Node o) {
        return this.name.compareTo(o.name);
    }
}

