/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.tools.rumen.DefaultOutputter;
import org.apache.hadoop.tools.rumen.InputDemuxer;
import org.apache.hadoop.tools.rumen.JobBuilder;
import org.apache.hadoop.tools.rumen.JobConfigurationParser;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.JobHistoryParserFactory;
import org.apache.hadoop.tools.rumen.JobHistoryUtils;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.Outputter;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.RewindableInputStream;
import org.apache.hadoop.tools.rumen.TopologyBuilder;
import org.apache.hadoop.tools.rumen.TraceBuilder;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TraceBuilder
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TraceBuilder.class);
    static final int RUN_METHOD_FAILED_EXIT_CODE = 3;
    TopologyBuilder topologyBuilder = new TopologyBuilder();
    Outputter<LoggedJob> traceWriter;
    Outputter<LoggedNetworkTopology> topologyWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TraceBuilder builder = new TraceBuilder();
        int result = 3;
        try {
            result = ToolRunner.run((Tool)builder, (String[])args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            try {
                builder.finish();
            }
            finally {
                if (result == 0) {
                    return;
                }
                System.exit(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        MyOptions options = new MyOptions(args, this.getConf());
        this.traceWriter = (Outputter)options.clazzTraceOutputter.newInstance();
        this.traceWriter.init(options.traceOutput, this.getConf());
        this.topologyWriter = new DefaultOutputter();
        this.topologyWriter.init(options.topologyOutput, this.getConf());
        try {
            JobBuilder jobBuilder = null;
            for (Path p : options.inputs) {
                InputDemuxer inputDemuxer = (InputDemuxer)options.inputDemuxerClass.newInstance();
                try {
                    inputDemuxer.bindTo(p, this.getConf());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to bind Path " + p + " .  Skipping..."), (Throwable)e);
                    continue;
                }
                Pair filePair = null;
                try {
                    while ((filePair = inputDemuxer.getNext()) != null) {
                        RewindableInputStream ris = new RewindableInputStream((InputStream)filePair.second());
                        JobHistoryParser parser = null;
                        try {
                            String jobID = JobHistoryUtils.extractJobID((String)((String)filePair.first()));
                            if (jobID == null) {
                                LOG.warn((Object)("File skipped: Invalid file name: " + (String)filePair.first()));
                                continue;
                            }
                            if (jobBuilder == null || !jobBuilder.getJobID().equals(jobID)) {
                                if (jobBuilder != null) {
                                    this.traceWriter.output((Object)jobBuilder.build());
                                }
                                jobBuilder = new JobBuilder(jobID);
                            }
                            if (JobHistoryUtils.isJobConfXml((String)((String)filePair.first()))) {
                                this.processJobConf(JobConfigurationParser.parse((InputStream)ris.rewind()), jobBuilder);
                                continue;
                            }
                            parser = JobHistoryParserFactory.getParser((RewindableInputStream)ris);
                            if (parser == null) {
                                LOG.warn((Object)("File skipped: Cannot find suitable parser: " + (String)filePair.first()));
                                continue;
                            }
                            this.processJobHistory(parser, jobBuilder);
                        }
                        finally {
                            if (parser == null) {
                                ris.close();
                                continue;
                            }
                            parser.close();
                            parser = null;
                        }
                    }
                }
                catch (Throwable t) {
                    if (filePair == null) continue;
                    LOG.warn((Object)("TraceBuilder got an error while processing the [possibly virtual] file " + (String)filePair.first() + " within Path " + p), t);
                }
                finally {
                    inputDemuxer.close();
                }
            }
            if (jobBuilder != null) {
                this.traceWriter.output((Object)jobBuilder.build());
                jobBuilder = null;
            } else {
                LOG.warn((Object)"No job found in traces: ");
            }
            this.topologyWriter.output((Object)this.topologyBuilder.build());
            return 0;
        }
        finally {
            this.traceWriter.close();
            this.topologyWriter.close();
        }
    }

    private void processJobConf(Properties properties, JobBuilder jobBuilder) {
        jobBuilder.process(properties);
        this.topologyBuilder.process(properties);
    }

    void processJobHistory(JobHistoryParser parser, JobBuilder jobBuilder) throws IOException {
        HistoryEvent e;
        while ((e = parser.nextEvent()) != null) {
            jobBuilder.process(e);
            this.topologyBuilder.process(e);
        }
        parser.close();
    }

    void finish() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.traceWriter, this.topologyWriter});
    }
}

