/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.tools.rumen.Hadoop20JHParser;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.LogRecordType;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.util.LineReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class Hadoop20JHParser
implements JobHistoryParser {
    final LineReader reader;
    static final String endLineString = " .";
    static final int internalVersion = 1;
    Map<String, HistoryEventEmitter> liveEmitters = new HashMap();
    Queue<HistoryEvent> remainingEvents = new LinkedList();

    public static boolean canParse(InputStream input) throws IOException {
        try {
            LineReader reader = new LineReader(input);
            Text buffer = new Text();
            return reader.readLine(buffer) != 0 && buffer.toString().equals("Meta VERSION=\"1\" .");
        }
        catch (EOFException e) {
            return false;
        }
    }

    public Hadoop20JHParser(InputStream input) throws IOException {
        this.reader = new LineReader(input);
    }

    public Hadoop20JHParser(LineReader reader) throws IOException {
        this.reader = reader;
    }

    public HistoryEvent nextEvent() {
        try {
            while (this.remainingEvents.isEmpty()) {
                ParsedLine line = new ParsedLine(this.getFullLine(), 1);
                LineType type = LineType.findLineType((LogRecordType)line.getType());
                if (type == null) continue;
                String name = type.getName(line);
                HistoryEventEmitter emitter = this.findOrMakeEmitter(name, type);
                Pair pair = emitter.emitterCore(line, name);
                if (pair.second() == HistoryEventEmitter.PostEmitAction.REMOVE_HEE) {
                    this.liveEmitters.remove(name);
                }
                this.remainingEvents = (Queue)pair.first();
            }
            return (HistoryEvent)this.remainingEvents.poll();
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    HistoryEventEmitter findOrMakeEmitter(String name, LineType type) {
        HistoryEventEmitter result = (HistoryEventEmitter)this.liveEmitters.get(name);
        if (result == null) {
            result = type.createEmitter();
            this.liveEmitters.put(name, result);
        }
        return result;
    }

    private String getOneLine() throws IOException {
        Text resultText = new Text();
        if (this.reader.readLine(resultText) == 0) {
            throw new EOFException("apparent bad line");
        }
        return resultText.toString();
    }

    private String getFullLine() throws IOException {
        String addedLine;
        String line = this.getOneLine();
        while (line.length() < " .".length()) {
            line = this.getOneLine();
        }
        if (line.endsWith(" .")) {
            return line;
        }
        StringBuilder sb = new StringBuilder(line);
        do {
            if ((addedLine = this.getOneLine()) == null) {
                return sb.toString();
            }
            sb.append("\n");
            sb.append(addedLine);
        } while (addedLine.length() < " .".length() || !" .".equals(addedLine.substring(addedLine.length() - " .".length())));
        return sb.toString();
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

