/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.ConcatenatedInputFilesDemuxer;
import org.apache.hadoop.tools.rumen.InputDemuxer;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;

public class ConcatenatedInputFilesDemuxer
implements InputDemuxer {
    private String name;
    private DelimitedInputStream input;
    private String knownNextFileName = null;
    private static int MAXIMUM_HEADER_LINE_LENGTH = 500;

    public void bindTo(Path path, Configuration conf) throws IOException {
        PossiblyDecompressedInputStream underlyingInput = null;
        if (this.name != null) {
            this.close();
        }
        this.name = path.getName();
        underlyingInput = new PossiblyDecompressedInputStream(path, conf);
        this.input = new DelimitedInputStream((InputStream)new BufferedInputStream((InputStream)underlyingInput), "\f!!FILE=", "!!\n");
        this.knownNextFileName = this.input.nextFileName();
        if (this.knownNextFileName == null) {
            this.close();
            return;
        }
    }

    public Pair<String, InputStream> getNext() throws IOException {
        if (this.knownNextFileName != null) {
            Pair result = new Pair((Object)this.knownNextFileName, (Object)this.input);
            this.knownNextFileName = null;
            return result;
        }
        String nextFileName = this.input.nextFileName();
        if (nextFileName == null) {
            return null;
        }
        return new Pair((Object)nextFileName, (Object)this.input);
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    static /* synthetic */ int access$000() {
        return MAXIMUM_HEADER_LINE_LENGTH;
    }
}

