/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.AbstractClusterStory;
import org.apache.hadoop.tools.rumen.ClusterTopologyReader;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.MachineNode;
import org.apache.hadoop.tools.rumen.Node;
import org.apache.hadoop.tools.rumen.RackNode;

public class ZombieCluster
extends AbstractClusterStory {
    private Node root;

    public ZombieCluster(LoggedNetworkTopology topology, MachineNode defaultNode) {
        this.buildCluster(topology, defaultNode);
    }

    public ZombieCluster(Path path, MachineNode defaultNode, Configuration conf) throws IOException {
        this(new ClusterTopologyReader(path, conf).get(), defaultNode);
    }

    public ZombieCluster(InputStream input, MachineNode defaultNode) throws IOException {
        this(new ClusterTopologyReader(input).get(), defaultNode);
    }

    public Node getClusterTopology() {
        return this.root;
    }

    private final void buildCluster(LoggedNetworkTopology topology, MachineNode defaultNode) {
        IdentityHashMap<LoggedNetworkTopology, Integer> levelMapping = new IdentityHashMap<LoggedNetworkTopology, Integer>();
        ArrayDeque<LoggedNetworkTopology> unvisited = new ArrayDeque<LoggedNetworkTopology>();
        unvisited.add(topology);
        levelMapping.put(topology, 0);
        int leafLevel = -1;
        LoggedNetworkTopology n = (LoggedNetworkTopology)unvisited.poll();
        while (n != null) {
            int level = (Integer)levelMapping.get(n);
            List children = n.getChildren();
            if (children == null || children.isEmpty()) {
                if (leafLevel == -1) {
                    leafLevel = level;
                } else if (leafLevel != level) {
                    throw new IllegalArgumentException("Leaf nodes are not on the same level");
                }
            } else {
                for (LoggedNetworkTopology child : children) {
                    levelMapping.put(child, level + 1);
                    unvisited.addFirst(child);
                }
            }
            n = (LoggedNetworkTopology)unvisited.poll();
        }
        Node[] path = new Node[leafLevel];
        unvisited.add(topology);
        LoggedNetworkTopology n2 = (LoggedNetworkTopology)unvisited.poll();
        while (n2 != null) {
            MachineNode current;
            int level = (Integer)levelMapping.get(n2);
            if (level == leafLevel) {
                MachineNode.Builder builder = new MachineNode.Builder(n2.getName().getValue(), level);
                if (defaultNode != null) {
                    builder.cloneFrom(defaultNode);
                }
                current = builder.build();
            } else {
                current = level == leafLevel - 1 ? new RackNode(n2.getName().getValue(), level) : new Node(n2.getName().getValue(), level);
                path[level] = current;
                for (LoggedNetworkTopology child : n2.getChildren()) {
                    unvisited.addFirst(child);
                }
            }
            if (level != 0) {
                path[level - 1].addChild((Node)current);
            }
            n2 = (LoggedNetworkTopology)unvisited.poll();
        }
        this.root = path[0];
    }
}

