/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.List;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;

public class ReduceTaskAttemptInfo
extends TaskAttemptInfo {
    private long shuffleTime;
    private long mergeTime;
    private long reduceTime;

    public ReduceTaskAttemptInfo(TaskStatus.State state, TaskInfo taskInfo, long shuffleTime, long mergeTime, long reduceTime, List<List<Integer>> allSplits) {
        super(state, taskInfo, allSplits == null ? LoggedTaskAttempt.SplitVectorKind.getNullSplitsVector() : allSplits);
        this.shuffleTime = shuffleTime;
        this.mergeTime = mergeTime;
        this.reduceTime = reduceTime;
    }

    @Deprecated
    public ReduceTaskAttemptInfo(TaskStatus.State state, TaskInfo taskInfo, long shuffleTime, long mergeTime, long reduceTime) {
        this(state, taskInfo, shuffleTime, mergeTime, reduceTime, null);
    }

    public long getReduceRuntime() {
        return this.reduceTime;
    }

    public long getShuffleRuntime() {
        return this.shuffleTime;
    }

    public long getMergeRuntime() {
        return this.mergeTime;
    }

    public long getRuntime() {
        return this.getShuffleRuntime() + this.getMergeRuntime() + this.getReduceRuntime();
    }
}

